/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.config;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogErrorHandling
extends AbstractEditErrorHandler {
    protected ICellEditor editor;
    private String failureShellTitle = Messages.getString("DialogErrorHandlingStrategy.failureTitle");
    private String conversionFailureShellTitle = Messages.getString("DialogErrorHandlingStrategy.conversionFailureTitle");
    private String validationFailureShellTitle = Messages.getString("DialogErrorHandlingStrategy.validationFailureTitle");
    private String changeButtonLabel = Messages.getString("DialogErrorHandlingStrategy.warningDialog.changeButton");
    private String discardButtonLabel = Messages.getString("DialogErrorHandlingStrategy.warningDialog.discardButton");

    public DialogErrorHandling() {
        super(null);
    }

    public DialogErrorHandling(IEditErrorHandler underlyingErrorHandler) {
        super(underlyingErrorHandler);
    }

    public void displayError(ICellEditor cellEditor, Exception e) {
        super.displayError(cellEditor, e);
        this.editor = cellEditor;
        String shellTitle = this.failureShellTitle;
        if (e instanceof ConversionFailedException && this.conversionFailureShellTitle != null) {
            shellTitle = this.conversionFailureShellTitle;
        } else if (e instanceof ValidationFailedException && this.validationFailureShellTitle != null) {
            shellTitle = this.validationFailureShellTitle;
        }
        this.showWarningDialog(e.getLocalizedMessage(), shellTitle);
    }

    protected void showWarningDialog(String dialogMessage, String dialogTitle) {
        MessageDialog warningDialog;
        if (!this.isWarningDialogActive() && dialogMessage != null && (warningDialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 4, new String[]{this.changeButtonLabel, this.discardButtonLabel}, 0)).open() == 1) {
            this.editor.close();
        }
    }

    protected boolean isWarningDialogActive() {
        Shell control = Display.getCurrent().getActiveShell();
        return control != null && (this.conversionFailureShellTitle.equals(control.getText()) || this.validationFailureShellTitle.equals(control.getText()) || this.failureShellTitle.equals(control.getText()));
    }

    public String getFailureShellTitle() {
        return this.failureShellTitle;
    }

    public void setFailureShellTitle(String failureShellTitle) {
        this.failureShellTitle = failureShellTitle;
    }

    public String getConversionFailureShellTitle() {
        return this.conversionFailureShellTitle;
    }

    public void setConversionFailureShellTitle(String conversionFailureShellTitle) {
        this.conversionFailureShellTitle = conversionFailureShellTitle;
    }

    public String getValidationFailureShellTitle() {
        return this.validationFailureShellTitle;
    }

    public void setValidationFailureShellTitle(String validationFailureShellTitle) {
        this.validationFailureShellTitle = validationFailureShellTitle;
    }

    public String getChangeButtonLabel() {
        return this.changeButtonLabel;
    }

    public void setChangeButtonLabel(String changeButtonLabel) {
        this.changeButtonLabel = changeButtonLabel;
    }

    public String getDiscardButtonLabel() {
        return this.discardButtonLabel;
    }

    public void setDiscardButtonLabel(String discardButtonLabel) {
        this.discardButtonLabel = discardButtonLabel;
    }
}

