/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.serializing;

import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.serializing.ISerializer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyDataToClipboardSerializer
implements ISerializer {
    private final ILayerCell[][] copiedCells;
    private final CopyDataToClipboardCommand command;

    public CopyDataToClipboardSerializer(ILayerCell[][] copiedCells, CopyDataToClipboardCommand command) {
        this.copiedCells = copiedCells;
        this.command = command;
    }

    public void serialize() {
        String cellDelimeter = this.command.getCellDelimeter();
        String rowDelimeter = this.command.getRowDelimeter();
        TextTransfer textTransfer = TextTransfer.getInstance();
        StringBuilder textData = new StringBuilder();
        int currentRow = 0;
        ILayerCell[][] iLayerCellArray = this.copiedCells;
        int n = this.copiedCells.length;
        int n2 = 0;
        while (n2 < n) {
            ILayerCell[] cells = iLayerCellArray[n2];
            int currentCell = 0;
            ILayerCell[] iLayerCellArray2 = cells;
            int n3 = cells.length;
            int n4 = 0;
            while (n4 < n3) {
                String delimeter;
                ILayerCell cell = iLayerCellArray2[n4];
                String string = delimeter = ++currentCell < cells.length ? cellDelimeter : "";
                if (cell != null) {
                    textData.append(String.valueOf(this.getTextForCell(cell)) + delimeter);
                } else {
                    textData.append(delimeter);
                }
                ++n4;
            }
            if (++currentRow < this.copiedCells.length) {
                textData.append(rowDelimeter);
            }
            ++n2;
        }
        Clipboard clipboard = new Clipboard(Display.getDefault());
        try {
            clipboard.setContents(new Object[]{textData.toString()}, new Transfer[]{textTransfer});
        }
        finally {
            clipboard.dispose();
        }
    }

    protected String getTextForCell(ILayerCell cell) {
        return String.valueOf(cell.getDataValue());
    }

    protected final CopyDataToClipboardCommand getCommand() {
        return this.command;
    }
}

