/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnChooser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommand;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnChooserUtils {
    public static final String RENAMED_COLUMN_INDICATOR = "*";

    public static void hideColumnEntries(List<ColumnEntry> removedItems, ColumnHideShowLayer hideShowLayer) {
        MultiColumnHideCommand hideCommand = new MultiColumnHideCommand((ILayer)hideShowLayer, ObjectUtils.asIntArray(ColumnChooserUtils.getColumnEntryPositions(removedItems)));
        hideShowLayer.doCommand(hideCommand);
    }

    public static void hideColumnPositions(List<Integer> removedPositions, ColumnHideShowLayer hideShowLayer) {
        MultiColumnHideCommand hideCommand = new MultiColumnHideCommand((ILayer)hideShowLayer, ObjectUtils.asIntArray(removedPositions));
        hideShowLayer.doCommand(hideCommand);
    }

    public static void showColumnEntries(List<ColumnEntry> addedItems, ColumnHideShowLayer hideShowLayer) {
        hideShowLayer.doCommand(new MultiColumnShowCommand(ObjectUtils.asIntArray(ColumnChooserUtils.getColumnEntryIndexes(addedItems))));
    }

    public static void showColumnIndexes(List<Integer> addedColumnIndexes, ColumnHideShowLayer hideShowLayer) {
        hideShowLayer.doCommand(new MultiColumnShowCommand(ObjectUtils.asIntArray(addedColumnIndexes)));
    }

    public static List<ColumnEntry> getHiddenColumnEntries(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer) {
        Collection<Integer> hiddenColumnIndexes = columnHideShowLayer.getHiddenColumnIndexes();
        ArrayList<ColumnEntry> hiddenColumnEntries = new ArrayList<ColumnEntry>();
        for (Integer hiddenColumnIndex : hiddenColumnIndexes) {
            String label = ColumnChooserUtils.getColumnLabel(columnHeaderLayer, columnHeaderDataLayer, hiddenColumnIndex);
            ColumnEntry columnEntry = new ColumnEntry(label, hiddenColumnIndex, -1);
            hiddenColumnEntries.add(columnEntry);
        }
        return hiddenColumnEntries;
    }

    public static String getColumnLabel(ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, Integer columnIndex) {
        String label = "";
        if (columnHeaderLayer.isColumnRenamed(columnIndex)) {
            label = String.valueOf(columnHeaderLayer.getRenamedColumnLabelByIndex(columnIndex)) + RENAMED_COLUMN_INDICATOR;
        } else {
            int position = columnHeaderDataLayer.getColumnPositionByIndex(columnIndex);
            label = columnHeaderDataLayer.getDataValueByPosition(position, 0).toString();
        }
        return label;
    }

    public static List<ColumnEntry> getVisibleColumnsEntries(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer) {
        int visibleColumnCount = columnHideShowLayer.getColumnCount();
        ArrayList<ColumnEntry> visibleColumnEntries = new ArrayList<ColumnEntry>();
        int i = 0;
        while (i < visibleColumnCount) {
            int index = columnHideShowLayer.getColumnIndexByPosition(i);
            String label = ColumnChooserUtils.getColumnLabel(columnHeaderLayer, columnHeaderDataLayer, index);
            ColumnEntry columnEntry = new ColumnEntry(label, index, i);
            visibleColumnEntries.add(columnEntry);
            ++i;
        }
        return visibleColumnEntries;
    }

    public static ColumnEntry find(List<ColumnEntry> entries, int indexToFind) {
        for (ColumnEntry columnEntry : entries) {
            if (!columnEntry.getIndex().equals(indexToFind)) continue;
            return columnEntry;
        }
        return null;
    }

    public static List<Integer> getColumnEntryPositions(List<ColumnEntry> columnEntries) {
        ArrayList<Integer> columnEntryPositions = new ArrayList<Integer>();
        for (ColumnEntry columnEntry : columnEntries) {
            columnEntryPositions.add(columnEntry.getPosition());
        }
        return columnEntryPositions;
    }

    public static List<Integer> getColumnEntryIndexes(List<ColumnEntry> columnEntries) {
        ArrayList<Integer> columnEntryIndexes = new ArrayList<Integer>();
        for (ColumnEntry columnEntry : columnEntries) {
            columnEntryIndexes.add(columnEntry.getIndex());
        }
        return columnEntryIndexes;
    }

    public static boolean containsIndex(List<ColumnEntry> entries, int indexToFind) {
        return ColumnChooserUtils.find(entries, indexToFind) != null;
    }
}

