/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.blink;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.blink.KeyStrategy;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.layer.event.PropertyUpdateEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateEventsCache<T> {
    public static final int INITIAL_DELAY = 100;
    public static final int TIME_TO_LIVE = 500;
    private final IRowIdAccessor<T> rowIdAccessor;
    private final KeyStrategy keyStrategy;
    private final ScheduledExecutorService cleanupScheduler;
    private Map<String, TimeStampedEvent> updateEvents;
    private ScheduledFuture<?> scheduledFutureCleanup;

    public UpdateEventsCache(IRowIdAccessor<T> rowIdAccessor, KeyStrategy keyStrategy, ScheduledExecutorService cleanupScheduler) {
        this.rowIdAccessor = rowIdAccessor;
        this.keyStrategy = keyStrategy;
        this.cleanupScheduler = cleanupScheduler;
        this.updateEvents = new HashMap<String, TimeStampedEvent>();
    }

    private Runnable getStaleUpdatesCleanupTask() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashMap<String, TimeStampedEvent> recentEvents = new HashMap<String, TimeStampedEvent>();
                Date recent = new Date(System.currentTimeMillis() - 500L);
                for (Map.Entry entry : UpdateEventsCache.this.updateEvents.entrySet()) {
                    if (!((TimeStampedEvent)entry.getValue()).timeRecieved.after(recent)) continue;
                    recentEvents.put((String)entry.getKey(), (TimeStampedEvent)entry.getValue());
                }
                Map map = UpdateEventsCache.this.updateEvents;
                synchronized (map) {
                    UpdateEventsCache.this.updateEvents = recentEvents;
                    UpdateEventsCache.this.checkUpdateEvents();
                }
            }
        };
    }

    private void checkUpdateEvents() {
        if (this.updateEvents.isEmpty()) {
            if (this.scheduledFutureCleanup != null) {
                this.scheduledFutureCleanup.cancel(true);
                this.scheduledFutureCleanup = null;
            }
        } else if (this.scheduledFutureCleanup == null) {
            this.scheduledFutureCleanup = this.cleanupScheduler.scheduleAtFixedRate(this.getStaleUpdatesCleanupTask(), 100L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void put(PropertyUpdateEvent<T> event) {
        String key = this.getKey(event);
        this.updateEvents.put(key, new TimeStampedEvent(event));
        this.checkUpdateEvents();
    }

    protected String getKey(PropertyUpdateEvent<T> event) {
        String rowId = this.rowIdAccessor.getRowId(event.getSourceBean()).toString();
        return this.getKey(event.getPropertyName(), rowId);
    }

    public String getKey(String columnProperty, String rowId) {
        return this.keyStrategy.getKey(columnProperty, rowId);
    }

    public PropertyUpdateEvent<T> getEvent(String key) {
        return this.updateEvents.get((Object)key).event;
    }

    public int getCount() {
        return this.updateEvents.size();
    }

    public boolean contains(String columnProperty, String rowId) {
        return this.updateEvents.containsKey(this.getKey(columnProperty, rowId));
    }

    public boolean isUpdated(String key) {
        return this.updateEvents.containsKey(key);
    }

    public void clear() {
        this.updateEvents.clear();
        this.checkUpdateEvents();
    }

    public void remove(String key) {
        this.updateEvents.remove(key);
        this.checkUpdateEvents();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeStampedEvent {
        Date timeRecieved;
        PropertyUpdateEvent<T> event;

        public TimeStampedEvent(PropertyUpdateEvent<T> event) {
            this.event = event;
            this.timeRecieved = new Date();
        }
    }
}

