/*******************************************************************************
 * Copyright (c) 2012 Original authors and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Original authors and others - initial API and implementation
 ******************************************************************************/
package org.eclipse.nebula.widgets.nattable.hideshow.event;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff.DiffTypeEnum;


public class HideColumnPositionsEvent extends ColumnStructuralChangeEvent {

	public HideColumnPositionsEvent(ILayer layer, Collection<Integer> columnPositions) {
		super(layer, PositionUtil.getRanges(columnPositions));
	}

	// Copy constructor
	protected HideColumnPositionsEvent(HideColumnPositionsEvent event) {
		super(event);
	}

	public HideColumnPositionsEvent cloneEvent() {
		return new HideColumnPositionsEvent(this);
	}

	public Collection<StructuralDiff> getColumnDiffs() {
		Collection<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();

		for (Range range : getColumnPositionRanges()) {
			StructuralDiff diff = new StructuralDiff(DiffTypeEnum.DELETE, range, new Range(range.start, range.start));
			columnDiffs.add(diff);
		}

		return columnDiffs;
	}

	@Override
	public boolean convertToLocal(ILayer localLayer) {
		super.convertToLocal(localLayer);
		return true;
	}

}
