/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class HorizontalRuleBlock
extends SourceBlock {
    private static final Pattern PATTERN = Pattern.compile(" {0,3}((\\*[ \t]*){3,}|(-[ \t]*){3,}|(_[ \t]*){3,})");

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        builder.setLocator(lineSequence.getCurrentLine().toLocator());
        builder.horizontalRule();
        lineSequence.advance();
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        return line != null && PATTERN.matcher(line.getText()).matches();
    }
}

