/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.wikitext.html.HtmlLanguage;
import org.eclipse.mylyn.wikitext.html.internal.HtmlSubsetDocumentBuilder;
import org.eclipse.mylyn.wikitext.html.internal.SpanHtmlElementStrategy;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentHandler;

public class HtmlSubsetLanguage
extends HtmlLanguage {
    private final Set<DocumentBuilder.BlockType> supportedBlockTypes;
    private final Set<DocumentBuilder.SpanType> supportedSpanTypes;
    private final int headingLevel;
    private final HtmlDocumentHandler documentHandler;
    private final List<SpanHtmlElementStrategy> spanElementStrategies;
    private final Map<DocumentBuilder.SpanType, String> tagNameSubstitutions;
    private final boolean xhtmlStrict;

    public HtmlSubsetLanguage(String name, HtmlDocumentHandler documentHandler, int headingLevel, Set<DocumentBuilder.BlockType> blockTypes, Set<DocumentBuilder.SpanType> spanTypes, Map<DocumentBuilder.SpanType, String> tagNameSubstitutions, List<SpanHtmlElementStrategy> spanElementStrategies) {
        this(name, documentHandler, headingLevel, blockTypes, spanTypes, tagNameSubstitutions, spanElementStrategies, false);
    }

    public HtmlSubsetLanguage(String name, HtmlDocumentHandler documentHandler, int headingLevel, Set<DocumentBuilder.BlockType> blockTypes, Set<DocumentBuilder.SpanType> spanTypes, Map<DocumentBuilder.SpanType, String> tagNameSubstitutions, List<SpanHtmlElementStrategy> spanElementStrategies, boolean xhtmlStrict) {
        this.setName((String)Preconditions.checkNotNull((Object)name));
        this.documentHandler = documentHandler;
        Preconditions.checkArgument((headingLevel >= 0 && headingLevel <= 6 ? 1 : 0) != 0, (Object)"headingLevel must be between 0 and 6");
        this.headingLevel = headingLevel;
        this.supportedBlockTypes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(blockTypes)));
        this.supportedSpanTypes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(spanTypes)));
        this.tagNameSubstitutions = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(tagNameSubstitutions)));
        this.spanElementStrategies = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(spanElementStrategies)));
        this.xhtmlStrict = xhtmlStrict;
        this.assertSubstitutedAreSupported();
    }

    public Set<DocumentBuilder.BlockType> getSupportedBlockTypes() {
        return this.supportedBlockTypes;
    }

    public Set<DocumentBuilder.SpanType> getSupportedSpanTypes() {
        return this.supportedSpanTypes;
    }

    public int getSupportedHeadingLevel() {
        return this.headingLevel;
    }

    public Map<DocumentBuilder.SpanType, String> getTagNameSubstitutions() {
        return this.tagNameSubstitutions;
    }

    @Override
    public HtmlSubsetDocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        HtmlSubsetDocumentBuilder builder = new HtmlSubsetDocumentBuilder(out, formatting);
        builder.setSupportedHeadingLevel(this.headingLevel);
        builder.setSupportedSpanTypes(this.supportedSpanTypes, this.spanElementStrategies);
        builder.setSupportedBlockTypes(this.supportedBlockTypes);
        builder.setXhtmlStrict(this.xhtmlStrict);
        this.addSpanTagNameSubstitutions(builder);
        if (this.documentHandler != null) {
            builder.setDocumentHandler(this.documentHandler);
        }
        return builder;
    }

    private void addSpanTagNameSubstitutions(HtmlSubsetDocumentBuilder builder) {
        for (Map.Entry<DocumentBuilder.SpanType, String> entry : this.tagNameSubstitutions.entrySet()) {
            builder.setElementNameOfSpanType(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public HtmlSubsetLanguage clone() {
        HtmlSubsetLanguage copy = new HtmlSubsetLanguage(this.getName(), this.documentHandler, this.headingLevel, this.supportedBlockTypes, this.supportedSpanTypes, this.tagNameSubstitutions, this.spanElementStrategies, this.xhtmlStrict);
        copy.setFileExtensions(this.getFileExtensions());
        copy.setExtendsLanguage(this.getExtendsLanguage());
        copy.setParseCleansHtml(this.isParseCleansHtml());
        return copy;
    }

    private void assertSubstitutedAreSupported() {
        for (DocumentBuilder.SpanType spanType : this.tagNameSubstitutions.keySet()) {
            Preconditions.checkState((boolean)this.supportedSpanTypes.contains(spanType), (String)"SpanType [%s] is unsupported. Cannot add substitution to unsupported span types.", (Object[])new Object[]{spanType});
        }
    }

    public boolean isXhtmlStrict() {
        return this.xhtmlStrict;
    }
}

