/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;

class TransformLineSequence
extends LineSequence {
    private final LineSequence delegate;
    private final Function<Line, Line> transform;

    public TransformLineSequence(LineSequence delegate, Function<Line, Line> transform) {
        this.delegate = (LineSequence)Preconditions.checkNotNull((Object)delegate);
        this.transform = (Function)Preconditions.checkNotNull(transform);
    }

    @Override
    public Line getCurrentLine() {
        Line line = this.delegate.getCurrentLine();
        if (line != null) {
            line = (Line)this.transform.apply((Object)line);
        }
        return line;
    }

    @Override
    public Line getNextLine() {
        Line line = this.delegate.getNextLine();
        if (line != null) {
            line = (Line)this.transform.apply((Object)line);
        }
        return line;
    }

    @Override
    public void advance() {
        this.delegate.advance();
    }

    @Override
    public LineSequence lookAhead() {
        return new TransformLineSequence(this.delegate.lookAhead(), this.transform);
    }
}

