/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.builder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class CompilationFileProvider {
    public static final String TARGET_FILE_EXTENSION = "java";
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    public IFile getFile(URI fileURI, IProject project) {
        Iterable storages = this.storage2UriMapper.getStorages(fileURI);
        if (Iterables.isEmpty((Iterable)storages)) {
            return null;
        }
        for (Pair pair : storages) {
            if (!project.equals(pair.getSecond())) continue;
            IStorage storage = (IStorage)pair.getFirst();
            if (!(storage instanceof IFile)) {
                return null;
            }
            return (IFile)storage;
        }
        return null;
    }

    public IFile getTargetFile(URI sourceFileURI, IProject project, SubMonitor monitor) throws CoreException {
        IFile sourceFile = this.getFile(sourceFileURI, project);
        if (sourceFile == null) {
            return null;
        }
        IPath sourceClasspathRelativePath = this.getClasspathRelativePath(sourceFile, this.getJavaProject(project));
        if (sourceClasspathRelativePath == null) {
            sourceClasspathRelativePath = sourceFile.getProjectRelativePath();
        }
        IPath targetClasspathRelativePath = sourceClasspathRelativePath.removeFileExtension().addFileExtension(TARGET_FILE_EXTENSION);
        IFolder targetFolder = this.getTargetFolder(project, monitor);
        if (!targetFolder.exists()) {
            targetFolder.create(true, true, (IProgressMonitor)monitor);
            this.makeSrcFolder(targetFolder, JavaCore.create((IProject)project));
        }
        IFile targetFile = targetFolder.getFile(targetClasspathRelativePath);
        return targetFile;
    }

    public IFolder getTargetFolder(IProject project, SubMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            throw new IllegalStateException("Xtend files must reside in a Java project");
        }
        IFolder targetFolder = project.getFolder(this.getTargetFolderName());
        return targetFolder;
    }

    public String getTargetFolderName() {
        return "xtend-gen";
    }

    protected void makeSrcFolder(IFolder folder, IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] classPath;
        IClasspathEntry newSourceEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
        IClasspathEntry[] iClasspathEntryArray = classPath = javaProject.getRawClasspath();
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
            if (classPathEntry.equals(newSourceEntry)) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + 1];
        System.arraycopy(classPath, 0, newClassPath, 1, classPath.length);
        newClassPath[0] = newSourceEntry;
        javaProject.setRawClasspath(newClassPath, null);
    }

    protected IPath getClasspathRelativePath(IFile file, IJavaProject javaProject) throws JavaModelException {
        IPath filePath = file.getFullPath();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (3 == classpathEntry.getEntryKind() && (path = classpathEntry.getPath()).isPrefixOf(filePath)) {
                return filePath.makeRelativeTo(path);
            }
            ++n2;
        }
        return null;
    }

    protected IJavaProject getJavaProject(IProject project) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            throw new IllegalStateException("Xtend files must reside in a Java project");
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject;
    }
}

