/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.linking;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.LocalVarDescription;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCallChecker {
    private PolymorphicDispatcher<String> dispatcher = new PolymorphicDispatcher("_case", 4, 4, Collections.singletonList(this));
    @Inject
    private XbaseTypeConformanceComputer conformance;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private FeatureCallToJavaMapping featureCall2JavaMapping;
    private EObject context;
    private EReference reference;

    public void setTypeProvider(ITypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void initialize(EObject context, EReference reference) {
        this.context = context;
        this.reference = reference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String check(IEObjectDescription input) {
        String issueCode;
        if (!(input instanceof IValidatedEObjectDescription)) return null;
        IValidatedEObjectDescription validatedDescription = (IValidatedEObjectDescription)input;
        JvmIdentifiableElement identifiable = validatedDescription.getEObjectOrProxy();
        if (identifiable.eIsProxy()) {
            identifiable = (JvmIdentifiableElement)EcoreUtil.resolve((EObject)identifiable, (EObject)this.context);
        }
        if (identifiable.eIsProxy()) {
            issueCode = "org.eclipse.xtext.xbase.validation.IssueCodes.unresolvable_proxy";
        } else if (!validatedDescription.isValid()) {
            if (!Strings.isEmpty((String)validatedDescription.getIssueCode())) return validatedDescription.getIssueCode();
            issueCode = "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature";
        } else {
            issueCode = (String)this.dispatcher.invoke(new Object[]{identifiable, this.context, this.reference, validatedDescription});
        }
        validatedDescription.setIssueCode(issueCode);
        return issueCode;
    }

    protected String _case(Object input, Object context, EReference ref, IValidatedEObjectDescription description) {
        return null;
    }

    protected String _case(JvmConstructor input, XConstructorCall context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        EList<XExpression> arguments = context.getArguments();
        if (!this.isValidNumberOfArguments((JvmExecutable)input, (List<XExpression>)arguments)) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        int expectedTypeArguments = input.getTypeParameters().size() + ((JvmTypeParameterDeclarator)input.getDeclaringType()).getTypeParameters().size();
        if (!context.getTypeArguments().isEmpty() && expectedTypeArguments != context.getTypeArguments().size()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments";
        }
        if (!this.areArgumentTypesValid((JvmExecutable)input, (List<XExpression>)arguments, jvmFeatureDescription.getContext())) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
        }
        return null;
    }

    protected String _case(JvmOperation input, XBinaryOperation context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        int irrelevantArguments = jvmFeatureDescription.getNumberOfIrrelevantArguments();
        if (input.getParameters().size() - irrelevantArguments != 1) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.getRightOperand() != null && context.getLeftOperand() != null) {
            JvmTypeReference rightOperandType = this.getTypeProvider().getType(context.getRightOperand(), true);
            if (rightOperandType == null) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
            JvmFormalParameter rightParam = (JvmFormalParameter)input.getParameters().get(0 + irrelevantArguments);
            if (!this.conformance.isConformant(rightParam.getParameterType(), rightOperandType, true)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
        }
        return null;
    }

    protected String _case(JvmOperation input, XAssignment context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        int irrelevantArguments = jvmFeatureDescription.getNumberOfIrrelevantArguments();
        if (input.getParameters().size() != 1 + irrelevantArguments) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.getValue() != null) {
            JvmTypeReference type = this.getTypeProvider().getType(context.getValue(), true);
            JvmFormalParameter valueParam = (JvmFormalParameter)input.getParameters().get(0 + irrelevantArguments);
            if (!this.isCompatibleArgument(valueParam.getParameterType(), type)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
        }
        return null;
    }

    protected String _case(JvmField input, XAssignment context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        if (input.isFinal()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_target_is_not_writeable";
        }
        if (input.isStatic()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
        }
        return null;
    }

    protected String _case(JvmField input, XMemberFeatureCall context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        if (!context.getMemberCallArguments().isEmpty()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.isExplicitOperationCall()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
        }
        if (input.isStatic()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
        }
        return null;
    }

    protected String _case(JvmIdentifiableElement input, XFeatureCall context, EReference ref, LocalVarDescription description) {
        if (context.isExplicitOperationCall()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses";
        }
        return null;
    }

    protected String _case(JvmField input, XFeatureCall context, EReference reference, JvmFeatureDescription jvmFeatureDescription) {
        if (context.getDeclaringType() == null) {
            if (input.isStatic()) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
            }
        } else if (!input.isStatic()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member";
        }
        if (context.isExplicitOperationCall()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
        }
        return null;
    }

    protected String _case(JvmOperation input, XMemberFeatureCall context, EReference ref, JvmFeatureDescription jvmFeatureDescription) {
        if (input.isStatic() && input.getParameters().size() == context.getMemberCallArguments().size()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member";
        }
        return this.checkJvmOperation(input, context, context.isExplicitOperationCall(), jvmFeatureDescription, context.getMemberCallArguments());
    }

    protected String _case(JvmOperation input, XFeatureCall context, EReference reference, JvmFeatureDescription jvmFeatureDescription) {
        if (context.getDeclaringType() != null && !input.isStatic()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member";
        }
        return this.checkJvmOperation(input, context, context.isExplicitOperationCall(), jvmFeatureDescription, context.getFeatureCallArguments());
    }

    protected String _case(JvmOperation input, XUnaryOperation context, EReference reference, JvmFeatureDescription jvmFeatureDescription) {
        if (input.getParameters().size() != 1) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (context.getOperand() != null) {
            JvmTypeReference operandType = this.getTypeProvider().getType(context.getOperand(), true);
            JvmFormalParameter param = (JvmFormalParameter)input.getParameters().get(0);
            if (!this.conformance.isConformant(param.getParameterType(), operandType, true)) {
                return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
            }
        }
        return null;
    }

    protected String checkJvmOperation(JvmOperation input, XAbstractFeatureCall context, boolean isExplicitOperationCall, JvmFeatureDescription jvmFeatureDescription, EList<XExpression> arguments) {
        List<XExpression> actualArguments = this.featureCall2JavaMapping.getActualArguments(context, (JvmIdentifiableElement)input, jvmFeatureDescription.getImplicitReceiver());
        if (!this.isValidNumberOfArguments((JvmExecutable)input, actualArguments)) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments";
        }
        if (!isExplicitOperationCall && !this.isSugaredMethodInvocationWithoutParanthesis(jvmFeatureDescription)) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.method_access_without_parentheses";
        }
        if (!context.getTypeArguments().isEmpty() && input.getTypeParameters().size() != context.getTypeArguments().size()) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments";
        }
        if (!this.areArgumentTypesValid((JvmExecutable)input, actualArguments, jvmFeatureDescription.getContext())) {
            return "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types";
        }
        return null;
    }

    protected boolean areArgumentTypesValid(JvmExecutable exectuable, List<XExpression> arguments, TypeArgumentContext typeArgumentContext) {
        int numberOfParameters = exectuable.getParameters().size();
        int parametersToCheck = exectuable.isVarArgs() ? numberOfParameters - 1 : numberOfParameters;
        int i = 0;
        while (i < parametersToCheck) {
            JvmTypeReference parameterType = ((JvmFormalParameter)exectuable.getParameters().get(i)).getParameterType();
            if (parameterType == null) {
                return true;
            }
            if (typeArgumentContext != null) {
                parameterType = typeArgumentContext.getLowerBound(parameterType);
            }
            XExpression argument = arguments.get(i);
            JvmTypeReference argumentType = this.getTypeProvider().getType(argument, true);
            if (!this.isCompatibleArgument(parameterType, argumentType)) {
                return false;
            }
            ++i;
        }
        if (exectuable.isVarArgs()) {
            int lastParamIndex = numberOfParameters - 1;
            JvmTypeReference lastParameterType = ((JvmFormalParameter)exectuable.getParameters().get(lastParamIndex)).getParameterType();
            if (!(lastParameterType.getType() instanceof JvmArrayType)) {
                throw new IllegalStateException("Unexpected var arg type: " + lastParameterType);
            }
            JvmTypeReference varArgType = ((JvmArrayType)lastParameterType.getType()).getComponentType();
            if (arguments.size() == numberOfParameters) {
                XExpression lastArgument = arguments.get(lastParamIndex);
                JvmTypeReference lastArgumentType = this.getTypeProvider().getType(lastArgument, true);
                if (this.isCompatibleArgument(lastParameterType, lastArgumentType)) {
                    return true;
                }
                if (!this.isCompatibleArgument(varArgType, lastArgumentType)) {
                    return false;
                }
            } else {
                int i2 = lastParamIndex;
                while (i2 < arguments.size()) {
                    XExpression argumentExpression = arguments.get(i2);
                    JvmTypeReference argumentType = this.getTypeProvider().getType(argumentExpression, true);
                    if (!this.isCompatibleArgument(varArgType, argumentType)) {
                        return false;
                    }
                    ++i2;
                }
            }
        }
        return true;
    }

    protected boolean isValidNumberOfArguments(JvmExecutable executable, List<XExpression> arguments) {
        int numberOfParameters = executable.getParameters().size();
        if (executable.getParameters().size() != arguments.size()) {
            if (!executable.isVarArgs()) {
                return false;
            }
            if (numberOfParameters - 1 > arguments.size()) {
                return false;
            }
        }
        return true;
    }

    protected boolean isSugaredMethodInvocationWithoutParanthesis(JvmFeatureDescription jvmFeatureDescription) {
        return jvmFeatureDescription.getKey().indexOf(40) == -1;
    }

    protected boolean isCompatibleArgument(JvmTypeReference declaredType, JvmTypeReference actualType) {
        if (actualType == null) {
            return true;
        }
        if (actualType.getType() instanceof JvmTypeParameter) {
            JvmTypeParameter type = (JvmTypeParameter)actualType.getType();
            if (type.getConstraints().isEmpty()) {
                return true;
            }
            for (JvmTypeConstraint constraint : type.getConstraints()) {
                if (!this.isCompatibleArgument(declaredType, constraint.getTypeReference())) continue;
                return true;
            }
            return false;
        }
        return this.conformance.isConformant(declaredType, actualType, true);
    }
}

