/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

public abstract class AbstractXbaseCompiler {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IEarlyExitComputer exitComputer;
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    @Inject
    private Primitives primitives;
    private PolymorphicDispatcher<Void> toJavaExprDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_toJavaExpression", (int)2, (int)2, (Object)this);
    private PolymorphicDispatcher<Void> toJavaStatementDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_toJavaStatement", (int)3, (int)3, (Object)this);
    @Inject
    private IdentifiableSimpleNameProvider nameProvider;

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    protected Primitives getPrimitives() {
        return this.primitives;
    }

    public IAppendable compile(XExpression obj, IAppendable appendable, JvmTypeReference expectedReturnType) {
        boolean isPrimitiveVoidExpected = this.typeReferences.is(expectedReturnType, Void.TYPE);
        boolean isPrimitiveVoid = this.isPrimitiveVoid(obj);
        boolean earlyExit = this.exitComputer.isEarlyExit(obj);
        this.internalToJavaStatement(obj, appendable, !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit);
        if (!isPrimitiveVoidExpected && !earlyExit) {
            appendable.append("\nreturn ");
            if (isPrimitiveVoid && !isPrimitiveVoidExpected) {
                appendable.append("null");
            } else {
                this.internalToJavaExpression(obj, appendable);
            }
            appendable.append(";");
        }
        return appendable;
    }

    protected boolean isPrimitiveVoid(XExpression xExpression) {
        JvmTypeReference type = this.getTypeProvider().getType(xExpression);
        return this.typeReferences.is(type, Void.TYPE);
    }

    protected void internalToJavaStatement(XExpression obj, IAppendable builder, boolean isReferenced) {
        this.toJavaStatementDispatcher.invoke(new Object[]{obj, builder, isReferenced});
    }

    public void toJavaExpression(XExpression obj, IAppendable appendable) {
        this.internalToJavaExpression(obj, appendable);
    }

    public void toJavaStatement(XExpression obj, IAppendable appendable, boolean isReferenced) {
        this.internalToJavaStatement(obj, appendable, isReferenced);
    }

    protected void internalToJavaExpression(XExpression obj, IAppendable appendable) {
        this.toJavaExprDispatcher.invoke(new Object[]{obj, appendable});
    }

    public void _toJavaStatement(XExpression func, IAppendable b, boolean isReferenced) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    public void _toJavaExpression(XExpression func, IAppendable b) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    public void _toJavaStatement(Void func, IAppendable b, boolean isReferenced) {
        throw new NullPointerException();
    }

    public void _toJavaExpression(Void func, IAppendable b) {
        throw new NullPointerException();
    }

    protected void serialize(JvmTypeReference type, EObject context, IAppendable appendable) {
        this.serialize(type, context, appendable, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard) {
        this.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject, boolean allowPrimitives) {
        if (type instanceof JvmWildcardTypeReference) {
            JvmWildcardTypeReference wildcard = (JvmWildcardTypeReference)type;
            if (!withoutConstraints) {
                appendable.append("?");
            }
            if (!wildcard.getConstraints().isEmpty()) {
                for (JvmTypeConstraint constraint : wildcard.getConstraints()) {
                    if (!(constraint instanceof JvmLowerBound)) continue;
                    if (!withoutConstraints) {
                        appendable.append(" super ");
                    }
                    this.serialize(constraint.getTypeReference(), context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                    return;
                }
                boolean first = true;
                for (JvmTypeConstraint constraint : wildcard.getConstraints()) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    if (first) {
                        if (!withoutConstraints) {
                            appendable.append(" extends ");
                        }
                        first = false;
                    } else {
                        if (withoutConstraints) {
                            throw new IllegalStateException("cannot have two upperbounds if type should be printed without constraints");
                        }
                        appendable.append(" & ");
                    }
                    this.serialize(constraint.getTypeReference(), context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                }
            } else if (withoutConstraints) {
                appendable.append("Object");
            }
        } else if (type instanceof JvmGenericArrayTypeReference) {
            this.serialize(((JvmGenericArrayTypeReference)type).getComponentType(), context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, true);
            appendable.append("[]");
        } else if (type instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)type;
            if ((paramsToWildcard || paramsToObject) && parameterized.getType() instanceof JvmTypeParameter) {
                JvmTypeParameter parameter = (JvmTypeParameter)parameterized.getType();
                if (context == null) {
                    throw new IllegalArgumentException("argument may not be null if parameters have to be replaced by wildcards");
                }
                if (!this.isLocalTypeParameter(context, parameter)) {
                    if (paramsToWildcard) {
                        appendable.append("?");
                    } else {
                        appendable.append("Object");
                    }
                    return;
                }
            }
            JvmType jvmType = allowPrimitives ? type.getType() : this.primitives.asWrapperTypeIfPrimitive(type).getType();
            appendable.append(jvmType);
            if (!parameterized.getArguments().isEmpty()) {
                appendable.append("<");
                int i = 0;
                while (i < parameterized.getArguments().size()) {
                    if (i != 0) {
                        appendable.append(",");
                    }
                    this.serialize((JvmTypeReference)parameterized.getArguments().get(i), context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                    ++i;
                }
                appendable.append(">");
            }
        } else if (type instanceof JvmAnyTypeReference) {
            appendable.append(type.getType());
        } else if (type instanceof JvmMultiTypeReference) {
            this.serialize(this.resolveMultiType(type), context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
        } else {
            throw new IllegalArgumentException(type == null ? null : type.toString());
        }
    }

    protected boolean isLocalTypeParameter(EObject context, JvmTypeParameter parameter) {
        return EcoreUtil.isAncestor((EObject)parameter.getDeclarator(), (EObject)context);
    }

    protected JvmTypeReference resolveMultiType(JvmTypeReference reference) {
        if (reference instanceof JvmMultiTypeReference) {
            JvmTypeReference result = this.typeConformanceComputer.getCommonSuperType((List)((JvmMultiTypeReference)reference).getReferences());
            if (result instanceof JvmMultiTypeReference) {
                return this.resolveMultiType(result);
            }
            return result;
        }
        return reference;
    }

    protected String getVarName(Object ex, IAppendable appendable) {
        String name = appendable.getName(ex);
        return name;
    }

    protected String declareNameInVariableScope(EObject declaration, IAppendable appendable) {
        String favoriteVariableName = this.makeJavaIdentifier(this.getFavoriteVariableName(declaration));
        String varName = appendable.declareVariable(declaration, favoriteVariableName);
        return varName;
    }

    public void setNameProvider(IdentifiableSimpleNameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    protected IdentifiableSimpleNameProvider getNameProvider() {
        return this.nameProvider;
    }

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof XVariableDeclaration) {
            return ((XVariableDeclaration)ex).getName();
        }
        if (ex instanceof JvmFormalParameter) {
            return ((JvmFormalParameter)ex).getName();
        }
        if (ex instanceof JvmIdentifiableElement) {
            return ((JvmIdentifiableElement)ex).getSimpleName();
        }
        if (ex instanceof XAbstractFeatureCall) {
            String name = this.nameProvider.getSimpleName(((XAbstractFeatureCall)ex).getFeature());
            int indexOf = name.indexOf(40);
            if (indexOf != -1) {
                name = name.substring(0, indexOf);
            }
            if ((indexOf = name.lastIndexOf(46)) != -1) {
                name = name.substring(indexOf + 1);
            }
            if (name.startsWith("get") && name.length() > 3) {
                name = Strings.toFirstLower((String)name.substring(3));
            }
            if (name.startsWith("to") && name.length() > 2) {
                name = Strings.toFirstLower((String)name.substring(2));
            }
            return "_" + name;
        }
        if (ex instanceof XConstructorCall) {
            String name = ((XConstructorCall)ex).getConstructor().getSimpleName();
            return "_" + Strings.toFirstLower((String)name);
        }
        return "_" + Strings.toFirstLower((String)ex.eClass().getName().toLowerCase());
    }

    protected String makeJavaIdentifier(String name) {
        return name.equals("this") ? "_this" : name;
    }

    protected void declareLocalVariable(XExpression expr, IAppendable b) {
        this.declareLocalVariable(expr, b, this.getDefaultValueLiteral(expr));
    }

    protected String getDefaultValueLiteral(XExpression expr) {
        JvmTypeReference type = this.getTypeProvider().getType(expr);
        if (this.primitives.isPrimitive(type)) {
            if (this.primitives.primitiveKind((JvmPrimitiveType)type.getType()) == Primitives.Primitive.Boolean) {
                return "false";
            }
            return "(" + type.getQualifiedName() + ") 0";
        }
        return "null";
    }

    protected void declareLocalVariable(XExpression expr, final IAppendable b, final String expression) {
        this.declareLocalVariable(expr, b, new Later(){

            public void exec() {
                b.append(expression);
            }
        });
    }

    protected void declareLocalVariable(XExpression expr, IAppendable b, Later expression) {
        JvmTypeReference expectedType;
        JvmTypeReference type = this.getTypeProvider().getType(expr);
        if (type instanceof JvmAnyTypeReference && (expectedType = this.getTypeProvider().getExpectedType(expr)) != null && !(expectedType.getType() instanceof JvmTypeParameter)) {
            type = expectedType;
        }
        String varName = this.declareNameInVariableScope(expr, b);
        b.append("\n");
        this.serialize(type, expr, b);
        b.append(" ").append(varName).append(" = ");
        expression.exec();
        b.append(";");
    }

    protected boolean isVariableDeclarationRequired(XExpression expr, IAppendable b) {
        return true;
    }

    protected TypeConformanceComputer getTypeConformanceComputer() {
        return this.typeConformanceComputer;
    }
}

