/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.compiler;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XIntLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValueBinaryOperation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationValueArray;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;

public class AnnotationCompiler {
    protected void _generate(XAnnotation annotation, IAppendable a) {
        IAppendable _append = a.append("@");
        JvmAnnotationType _annotationType = annotation.getAnnotationType();
        _append.append(_annotationType);
        XExpression _value = annotation.getValue();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_value, null);
        if (_operator_notEquals) {
            a.append("(");
            XExpression _value_1 = annotation.getValue();
            this.generate(_value_1, a);
            a.append(")");
        } else {
            EList<XAnnotationElementValuePair> _elementValuePairs = annotation.getElementValuePairs();
            boolean _isEmpty = _elementValuePairs.isEmpty();
            boolean _operator_not = BooleanExtensions.operator_not((boolean)_isEmpty);
            if (_operator_not) {
                Iterator _iterator;
                a.append("(");
                EList<XAnnotationElementValuePair> _elementValuePairs_1 = annotation.getElementValuePairs();
                Iterator iter = _iterator = _elementValuePairs_1.iterator();
                boolean _hasNext = iter.hasNext();
                Boolean _xwhileexpression = _hasNext;
                while (_xwhileexpression.booleanValue()) {
                    XAnnotationElementValuePair _next = (XAnnotationElementValuePair)iter.next();
                    this.generate(_next, a);
                    boolean _hasNext_1 = iter.hasNext();
                    if (_hasNext_1) {
                        a.append(",");
                    }
                    boolean _hasNext_2 = iter.hasNext();
                    _xwhileexpression = _hasNext_2;
                }
                a.append(")");
            }
        }
    }

    protected void _generate(XAnnotationElementValuePair binaryOp, IAppendable a) {
        JvmOperation _element = binaryOp.getElement();
        String _simpleName = _element.getSimpleName();
        IAppendable _append = a.append(_simpleName);
        _append.append(" = ");
        XExpression _value = binaryOp.getValue();
        this.generate(_value, a);
    }

    protected void _generate(XAnnotationElementValueBinaryOperation binaryOp, IAppendable a) {
        XExpression _leftOperand = binaryOp.getLeftOperand();
        this.generate(_leftOperand, a);
        a.append(" + ");
        XExpression _rightOperand = binaryOp.getRightOperand();
        this.generate(_rightOperand, a);
    }

    protected void _generate(XAnnotationValueArray array, IAppendable a) {
        Iterator _iterator;
        a.append("{");
        EList<XExpression> _values = array.getValues();
        Iterator iter = _iterator = _values.iterator();
        boolean _hasNext = iter.hasNext();
        Boolean _xwhileexpression = _hasNext;
        while (_xwhileexpression.booleanValue()) {
            XExpression _next = (XExpression)iter.next();
            this.generate(_next, a);
            boolean _hasNext_1 = iter.hasNext();
            if (_hasNext_1) {
                a.append(", ");
            }
            boolean _hasNext_2 = iter.hasNext();
            _xwhileexpression = _hasNext_2;
        }
        a.append("}");
    }

    protected void _generate(XFeatureCall featureCall, IAppendable a) {
        JvmDeclaredType _declaringType = featureCall.getDeclaringType();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_declaringType, null);
        if (_operator_notEquals) {
            JvmDeclaredType _declaringType_1 = featureCall.getDeclaringType();
            a.append(_declaringType_1);
            a.append(".");
        }
        JvmIdentifiableElement _feature = featureCall.getFeature();
        String _simpleName = _feature.getSimpleName();
        a.append(_simpleName);
    }

    protected void _generate(XStringLiteral stringLiteral, IAppendable a) {
        IAppendable _append = a.append("\"");
        String _value = stringLiteral.getValue();
        String _convertToJavaString = Strings.convertToJavaString((String)_value);
        IAppendable _append_1 = _append.append(_convertToJavaString);
        _append_1.append("\"");
    }

    protected void _generate(XBooleanLiteral booleanLiteral, IAppendable a) {
        boolean _isIsTrue = booleanLiteral.isIsTrue();
        a.append(_isIsTrue);
    }

    protected void _generate(XIntLiteral intLiteral, IAppendable a) {
        int _value = intLiteral.getValue();
        a.append(_value);
    }

    protected void _generate(XTypeLiteral typeLiteral, IAppendable a) {
        JvmType _type = typeLiteral.getType();
        IAppendable _append = a.append(_type);
        _append.append(".class");
    }

    public void generate(EObject featureCall, IAppendable a) {
        if (featureCall instanceof XFeatureCall && a instanceof IAppendable) {
            this._generate((XFeatureCall)featureCall, a);
        } else if (featureCall instanceof XBooleanLiteral && a instanceof IAppendable) {
            this._generate((XBooleanLiteral)featureCall, a);
        } else if (featureCall instanceof XIntLiteral && a instanceof IAppendable) {
            this._generate((XIntLiteral)featureCall, a);
        } else if (featureCall instanceof XStringLiteral && a instanceof IAppendable) {
            this._generate((XStringLiteral)featureCall, a);
        } else if (featureCall instanceof XTypeLiteral && a instanceof IAppendable) {
            this._generate((XTypeLiteral)featureCall, a);
        } else if (featureCall instanceof XAnnotation && a instanceof IAppendable) {
            this._generate((XAnnotation)featureCall, a);
        } else if (featureCall instanceof XAnnotationElementValueBinaryOperation && a instanceof IAppendable) {
            this._generate((XAnnotationElementValueBinaryOperation)featureCall, a);
        } else if (featureCall instanceof XAnnotationValueArray && a instanceof IAppendable) {
            this._generate((XAnnotationValueArray)featureCall, a);
        } else if (featureCall instanceof XAnnotationElementValuePair && a instanceof IAppendable) {
            this._generate((XAnnotationElementValuePair)featureCall, a);
        } else {
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(featureCall, a).toString());
        }
    }
}

