/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadingResourceAccess
implements IReferenceFinder.ILocalResourceAccess {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    @Override
    public <R> R readOnly(URI targetURI, IUnitOfWork<R, ResourceSet> work) {
        Iterable<Pair<IStorage, IProject>> storages = this.storage2UriMapper.getStorages(targetURI.trimFragment());
        for (Pair<IStorage, IProject> pair : storages) {
            ResourceSet resourceSet;
            IProject project = (IProject)pair.getSecond();
            if (project == null || (resourceSet = this.resourceSetProvider.get(project)) == null) continue;
            try {
                return (R)work.exec((Object)resourceSet);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        return null;
    }
}

