/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQueryData;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.SimpleAttributeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindReferenceQueryDataFactory {
    @Inject
    protected IGlobalServiceProvider globalServiceProvider;

    public IReferenceFinder.IQueryData createQueryData(EObject element, URI localResourceURI) {
        URI targetURI = EcoreUtil.getURI((EObject)element);
        ReferenceQueryData queryData = new ReferenceQueryData(targetURI, this.createTargetURIs(element), localResourceURI, this.createResultFilter(element), this.createLabel(element));
        return queryData;
    }

    protected Set<URI> createTargetURIs(EObject target) {
        return Collections.singleton(EcoreUtil.getURI((EObject)target));
    }

    protected Predicate<IReferenceDescription> createResultFilter(EObject target) {
        return null;
    }

    protected String createLabel(EObject target) {
        QueryLabelProvider queryLabelProvider = (QueryLabelProvider)this.globalServiceProvider.findService(target, QueryLabelProvider.class);
        if (queryLabelProvider == null || target.eIsProxy() || target.eResource() == null) {
            return "";
        }
        return queryLabelProvider.get(target);
    }

    public static class QueryLabelProvider {
        @Inject
        private IStorage2UriMapper storage2UriMapper;
        @Inject
        private IQualifiedNameProvider qualifiedNameProvider;
        @Inject
        private IQualifiedNameConverter qualifiedNameConverter;

        public String get(EObject target) {
            StringBuilder builder = new StringBuilder();
            builder.append(Messages.FindReferencesHandler_labelPrefix);
            QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(target);
            if (qualifiedName != null) {
                builder.append(this.qualifiedNameConverter.toString(qualifiedName));
            } else {
                String simpleName = (String)SimpleAttributeResolver.NAME_RESOLVER.getValue(target);
                if (simpleName != null) {
                    builder.append(simpleName);
                } else {
                    builder.append(target.eResource().getURIFragment(target));
                }
            }
            Iterator<Pair<IStorage, IProject>> storages = this.storage2UriMapper.getStorages(EcoreUtil.getURI((EObject)target)).iterator();
            if (storages.hasNext()) {
                builder.append(Messages.FindReferencesHandler_1).append(((IStorage)storages.next().getFirst()).getFullPath().toString()).append(Messages.FindReferencesHandler_2);
            }
            return builder.toString();
        }
    }
}

