/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.impl;

import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

public class Range {
    private int offset;
    private int endOffset;

    public Range(INode node) {
        this(node.getTotalOffset(), node.getTotalEndOffset());
    }

    public Range(int fromOffset, int endOffset) {
        this.offset = fromOffset;
        this.endOffset = endOffset;
    }

    public void merge(INode node) {
        this.merge(node.getTotalOffset(), node.getTotalEndOffset());
    }

    public void merge(int fromOffset, int endOffset) {
        this.offset = Math.min(this.offset, fromOffset);
        this.endOffset = Math.max(this.endOffset, endOffset);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int fromOffset) {
        this.offset = fromOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public int getLength() {
        return this.endOffset - this.offset;
    }

    public void mergeAllSyntaxErrors(INode node) {
        if (node.getSyntaxErrorMessage() != null) {
            this.merge(node);
        } else {
            boolean errorSeen = false;
            BidiTreeIterator<INode> iterator = node.getAsTreeIterable().iterator();
            while (!errorSeen && iterator.hasNext()) {
                INode next = iterator.next();
                if (next.getSyntaxErrorMessage() == null) continue;
                this.merge(next);
                errorSeen = true;
            }
            if (errorSeen) {
                iterator = node.getAsTreeIterable().iterator();
                errorSeen = false;
                while (!errorSeen && iterator.hasPrevious()) {
                    INode prev = iterator.previous();
                    if (prev.getSyntaxErrorMessage() != null) {
                        this.merge(prev);
                        errorSeen = true;
                        continue;
                    }
                    if (!(prev instanceof ILeafNode) || prev.getGrammarElement() != null) continue;
                    this.merge(prev);
                    errorSeen = true;
                }
            }
        }
    }

    public String toString() {
        return "range [" + this.offset + " - " + this.endOffset + "]";
    }
}

