/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.internal.AbstractHiddenRegionFormatter;

public class DoubleHiddenRegionFormatter
extends AbstractHiddenRegionFormatter {
    private final IHiddenRegionFormatting first;
    private final IHiddenRegionFormatting second;

    public DoubleHiddenRegionFormatter(IHiddenRegionFormatting first, IHiddenRegionFormatting second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void autowrap() {
        Integer old2;
        Integer old1 = this.first.getAutowrap();
        if (old1 == null || old1 < 0) {
            this.first.setAutowrap(0);
        }
        if ((old2 = this.second.getAutowrap()) == null || old2 < 0) {
            this.second.setAutowrap(0);
        }
    }

    @Override
    public void autowrap(int triggerLength) {
        this.first.setAutowrap(triggerLength);
        this.second.setAutowrap(triggerLength);
    }

    @Override
    public FormatterRequest getRequest() {
        return this.first.getRequest();
    }

    @Override
    public void indent() {
        Integer inc = this.first.getIndentationIncrease();
        Integer dec = this.second.getIndentationDecrease();
        this.first.setIndentationIncrease(inc == null ? 1 : inc + 1);
        this.second.setIndentationDecrease(dec == null ? 1 : dec + 1);
    }

    @Override
    public void noAutowrap() {
        this.first.setAutowrap(-1);
        this.second.setAutowrap(-1);
    }

    @Override
    public void noIndentation() {
        this.first.setNoIndentation(true);
        this.second.setNoIndentation(true);
    }

    @Override
    public void setNewLines(int minNewLines, int defaultNewLines, int maxNewLines) {
        this.first.setNewLinesMin(minNewLines);
        this.first.setNewLinesDefault(defaultNewLines);
        this.first.setNewLinesMax(maxNewLines);
        this.second.setNewLinesMin(minNewLines);
        this.second.setNewLinesDefault(defaultNewLines);
        this.second.setNewLinesMax(maxNewLines);
    }

    @Override
    public void setOnAutowrap(IAutowrapFormatter formatter) {
        this.autowrap();
        this.first.setOnAutowrap(formatter);
        this.second.setOnAutowrap(formatter);
    }

    @Override
    public void setPriority(int priority) {
        this.first.setPriority(priority);
        this.second.setPriority(priority);
    }

    @Override
    public void setSpace(String space) {
        this.first.setSpace(space);
        this.second.setSpace(space);
    }
}

