/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Objects;
import com.google.inject.Injector;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.annotations.IClassAnnotation;

public class CodeConfig
implements IGuiceAwareGeneratorComponent {
    private static final String FILE_HEADER_VAR_TIME = "${time}";
    private static final String FILE_HEADER_VAR_DATE = "${date}";
    private static final String FILE_HEADER_VAR_YEAR = "${year}";
    private static final String FILE_HEADER_VAR_USER = "${user}";
    private static final String FILE_HEADER_VAR_VERSION = "${version}";
    @Accessors
    private String encoding = Charset.defaultCharset().name();
    @Accessors
    private String lineDelimiter = Strings.newLine();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private String fileHeader;
    private String fileHeaderTemplate = "/*\n * generated by Xtext\n */";
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final List<IClassAnnotation> classAnnotations = CollectionLiterals.newArrayList((Object[])new IClassAnnotation[0]);
    @Accessors
    private boolean preferXtendStubs = true;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XtextVersion xtextVersion;

    public void setFileHeader(String fileHeaderTemplate) {
        this.fileHeaderTemplate = fileHeaderTemplate;
    }

    public void addClassAnnotation(IClassAnnotation annotation) {
        this.classAnnotations.add(annotation);
    }

    @Override
    public void initialize(Injector injector) {
        String fileHeader;
        boolean _notEquals;
        XtextVersion _current;
        injector.injectMembers((Object)this);
        this.xtextVersion = _current = XtextVersion.getCurrent();
        if (this.lineDelimiter == null) {
            this.lineDelimiter = "\n";
        }
        boolean bl = _notEquals = !Objects.equal((Object)(fileHeader = this.fileHeaderTemplate), null);
        if (_notEquals) {
            boolean _contains_4;
            boolean _contains_3;
            boolean _contains_2;
            boolean _contains_1;
            boolean _contains = fileHeader.contains(FILE_HEADER_VAR_TIME);
            if (_contains) {
                String _replace;
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
                Date _date = new Date();
                String time = dateFormat.format(_date);
                fileHeader = _replace = fileHeader.replace(FILE_HEADER_VAR_TIME, time);
            }
            if (_contains_1 = fileHeader.contains(FILE_HEADER_VAR_DATE)) {
                String _replace_1;
                SimpleDateFormat dateFormat_1 = new SimpleDateFormat("MMM d, yyyy");
                Date _date_1 = new Date();
                String date = dateFormat_1.format(_date_1);
                fileHeader = _replace_1 = fileHeader.replace(FILE_HEADER_VAR_DATE, date);
            }
            if (_contains_2 = fileHeader.contains(FILE_HEADER_VAR_YEAR)) {
                String _replace_2;
                SimpleDateFormat dateFormat_2 = new SimpleDateFormat("yyyy");
                Date _date_2 = new Date();
                String year = dateFormat_2.format(_date_2);
                fileHeader = _replace_2 = fileHeader.replace(FILE_HEADER_VAR_YEAR, year);
            }
            if (_contains_3 = fileHeader.contains(FILE_HEADER_VAR_USER)) {
                boolean _notEquals_1;
                String user = System.getProperty("user.name");
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)user, null);
                if (_notEquals_1) {
                    String _replace_3;
                    fileHeader = _replace_3 = fileHeader.replace(FILE_HEADER_VAR_USER, user);
                }
            }
            if (_contains_4 = fileHeader.contains(FILE_HEADER_VAR_VERSION)) {
                String _replace_4;
                String _string = this.xtextVersion.toString();
                fileHeader = _replace_4 = fileHeader.replace(FILE_HEADER_VAR_VERSION, _string);
            }
        }
        this.fileHeader = fileHeader;
    }

    public String getClassAnnotationsAsString() {
        boolean _isEmpty = this.classAnnotations.isEmpty();
        if (_isEmpty) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            String _string = annotation.toString();
            StringBuilder _append = stringBuilder.append(_string);
            String _newLine = Strings.newLine();
            _append.append(_newLine);
        }
        return stringBuilder.toString();
    }

    public String getAnnotationImportsAsString() {
        boolean _isEmpty = this.classAnnotations.isEmpty();
        if (_isEmpty) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            TypeReference importString = annotation.getAnnotationImport();
            if (importString == null) continue;
            StringBuilder _append = stringBuilder.append("import ");
            StringBuilder _append_1 = _append.append(importString);
            StringBuilder _append_2 = _append_1.append(";");
            String _newLine = Strings.newLine();
            _append_2.append(_newLine);
        }
        return stringBuilder.toString();
    }

    @Pure
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Pure
    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    @Pure
    public String getFileHeader() {
        return this.fileHeader;
    }

    @Pure
    public List<IClassAnnotation> getClassAnnotations() {
        return this.classAnnotations;
    }

    @Pure
    public boolean isPreferXtendStubs() {
        return this.preferXtendStubs;
    }

    public void setPreferXtendStubs(boolean preferXtendStubs) {
        this.preferXtendStubs = preferXtendStubs;
    }

    @Pure
    public XtextVersion getXtextVersion() {
        return this.xtextVersion;
    }
}

