/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ASTFlattenerUtils {
    public boolean isDummyType(AbstractTypeDeclaration it) {
        if (it instanceof TypeDeclaration) {
            int _modifiers;
            boolean _equals_1;
            boolean _isInterface;
            boolean _not;
            boolean _and = false;
            boolean _and_1 = false;
            SimpleName _name = ((TypeDeclaration)it).getName();
            String _identifier = _name.getIdentifier();
            boolean _equals = "MISSING".equals(_identifier);
            _and_1 = !_equals ? false : (_not = !(_isInterface = ((TypeDeclaration)it).isInterface()));
            _and = !_and_1 ? false : (_equals_1 = (_modifiers = ((TypeDeclaration)it).getModifiers()) == 0);
            return _and;
        }
        return false;
    }

    public boolean isOverrideMethod(MethodDeclaration declaration) {
        boolean _notEquals;
        Functions.Function1<Annotation, Boolean> _function;
        List _modifiers = declaration.modifiers();
        Iterable _filter = Iterables.filter((Iterable)_modifiers, Annotation.class);
        boolean _exists = IterableExtensions.exists((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                Name _typeName = it.getTypeName();
                String _string = _typeName.toString();
                return Objects.equal((Object)"Override", (Object)_string);
            }
        }));
        if (_exists) {
            return true;
        }
        IMethodBinding iMethodBinding = declaration.resolveBinding();
        boolean bl = _notEquals = !Objects.equal((Object)iMethodBinding, null);
        if (_notEquals) {
            ITypeBinding _declaringClass = iMethodBinding.getDeclaringClass();
            IMethodBinding _findOverride = this.findOverride(iMethodBinding, _declaringClass);
            return !Objects.equal((Object)_findOverride, null);
        }
        return false;
    }

    public IMethodBinding findOverride(IMethodBinding method, ITypeBinding type) {
        return this.findOverride(method, type, false);
    }

    public IMethodBinding findOverride(IMethodBinding method, ITypeBinding type, boolean onlyPrimarylevel) {
        boolean _equals;
        boolean _notEquals;
        ITypeBinding superclass = type.getSuperclass();
        IMethodBinding overridden = null;
        boolean bl = _notEquals = !Objects.equal((Object)superclass, null);
        if (_notEquals) {
            IMethodBinding _internalFindOverride;
            overridden = _internalFindOverride = this.internalFindOverride(method, superclass, onlyPrimarylevel);
        }
        if (_equals = Objects.equal(overridden, null)) {
            ITypeBinding[] _interfaces;
            ITypeBinding[] iTypeBindingArray = _interfaces = type.getInterfaces();
            int n = _interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _notEquals_1;
                ITypeBinding interfaze = iTypeBindingArray[n2];
                IMethodBinding _internalFindOverride_1 = this.internalFindOverride(method, interfaze, onlyPrimarylevel);
                overridden = _internalFindOverride_1;
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)overridden, null);
                if (_notEquals_1) {
                    return overridden;
                }
                ++n2;
            }
        }
        return overridden;
    }

    private IMethodBinding internalFindOverride(final IMethodBinding method, ITypeBinding superType, boolean onlyPrimarylevel) {
        boolean _equals;
        IMethodBinding[] _declaredMethods = superType.getDeclaredMethods();
        Functions.Function1<IMethodBinding, Boolean> _function = new Functions.Function1<IMethodBinding, Boolean>(){

            public Boolean apply(IMethodBinding it) {
                return method.overrides(it);
            }
        };
        Iterable superClassOverride = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_declaredMethods)), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)superClassOverride);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return ((IMethodBinding[])Conversions.unwrapArray((Object)superClassOverride, IMethodBinding.class))[0];
        }
        if (!onlyPrimarylevel) {
            return this.findOverride(method, superType);
        }
        return null;
    }

    public String handleVariableDeclaration(Iterable<? extends ASTNode> modifier) {
        Iterable _filter = Iterables.filter(modifier, Modifier.class);
        boolean _isFinal = this.isFinal(_filter);
        if (_isFinal) {
            return "val";
        }
        return "var";
    }

    public boolean isNotSupportedInnerType(TypeDeclaration it) {
        Functions.Function1<Modifier, Boolean> _function;
        List _modifiers;
        Iterable _filter;
        boolean _exists;
        boolean _not_1;
        boolean _not;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _isInterface = it.isInterface();
        boolean bl = _not = !_isInterface;
        if (!_not) {
            _and_1 = false;
        } else {
            boolean bl2 = _and_1 = it.getParent() instanceof TypeDeclaration || it.getParent() instanceof Block;
        }
        _and = !_and_1 ? false : (_not_1 = !(_exists = IterableExtensions.exists((Iterable)(_filter = Iterables.filter((Iterable)(_modifiers = it.modifiers()), Modifier.class)), (Functions.Function1)(_function = new Functions.Function1<Modifier, Boolean>(){

            public Boolean apply(Modifier it) {
                return it.isStatic();
            }
        }))));
        return _and;
    }

    public boolean isNotSupportedInnerType(TypeDeclarationStatement it) {
        ASTNode _parent = it.getParent();
        return _parent instanceof Block;
    }

    public boolean isFinal(Iterable<Modifier> modifiers) {
        Iterable _filter = Iterables.filter(modifiers, Modifier.class);
        Functions.Function1<Modifier, Boolean> _function = new Functions.Function1<Modifier, Boolean>(){

            public Boolean apply(Modifier it) {
                return it.isFinal();
            }
        };
        return IterableExtensions.exists((Iterable)_filter, (Functions.Function1)_function);
    }

    public boolean isStatic(Iterable<IExtendedModifier> modifiers) {
        Iterable _filter = Iterables.filter(modifiers, Modifier.class);
        Functions.Function1<Modifier, Boolean> _function = new Functions.Function1<Modifier, Boolean>(){

            public Boolean apply(Modifier it) {
                return it.isStatic();
            }
        };
        return IterableExtensions.exists((Iterable)_filter, (Functions.Function1)_function);
    }

    public boolean isStaticMemberCall(MethodInvocation methInv) {
        IMethodBinding _resolveMethodBinding = methInv.resolveMethodBinding();
        return this.isStaticBinding((IBinding)_resolveMethodBinding);
    }

    public boolean isStaticMemberCall(QualifiedName expr) {
        IBinding _resolveBinding = expr.resolveBinding();
        return this.isStaticBinding(_resolveBinding);
    }

    public boolean isStaticMemberCall(FieldAccess expr) {
        IVariableBinding _resolveFieldBinding = expr.resolveFieldBinding();
        return this.isStaticBinding((IBinding)_resolveFieldBinding);
    }

    private boolean isStaticBinding(IBinding binding) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)binding, null);
        if (_notEquals) {
            int _modifiers = binding.getModifiers();
            return Modifier.isStatic((int)_modifiers);
        }
        return false;
    }

    public boolean isPackageVisibility(Iterable<Modifier> modifier) {
        Functions.Function1<Modifier, Boolean> _function = new Functions.Function1<Modifier, Boolean>(){

            public Boolean apply(Modifier it) {
                boolean _isProtected;
                boolean _isPrivate;
                boolean _or = false;
                boolean _or_1 = false;
                boolean _isPublic = it.isPublic();
                _or_1 = _isPublic ? true : (_isPrivate = it.isPrivate());
                _or = _or_1 ? true : (_isProtected = it.isProtected());
                return _or;
            }
        };
        Iterable _filter = IterableExtensions.filter(modifier, (Functions.Function1)_function);
        return IterableExtensions.isEmpty((Iterable)_filter);
    }

    public boolean canHandleAnnotation(ASTNode node) {
        return !(node instanceof VariableDeclarationStatement);
    }

    public boolean shouldConvertName(SimpleName it) {
        boolean _or = false;
        ASTNode _parent = it.getParent();
        _or = _parent instanceof FieldAccess ? true : it.getParent() instanceof VariableDeclarationFragment && it.getParent().getParent() instanceof FieldDeclaration;
        return _or;
    }

    public boolean isLambdaCase(ClassInstanceCreation creation) {
        List _bodyDeclarations;
        int _size;
        boolean _equals;
        boolean _notEquals;
        AnonymousClassDeclaration anonymousClazz = creation.getAnonymousClassDeclaration();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)anonymousClazz, null);
        _and = !_notEquals ? false : (_equals = (_size = (_bodyDeclarations = anonymousClazz.bodyDeclarations()).size()) == 1);
        if (_and) {
            Type _type;
            ITypeBinding _resolveBinding;
            boolean _notEquals_1;
            List _bodyDeclarations_1 = anonymousClazz.bodyDeclarations();
            Object declaredMethod = _bodyDeclarations_1.get(0);
            boolean _and_1 = false;
            _and_1 = !(declaredMethod instanceof MethodDeclaration) ? false : (_notEquals_1 = !Objects.equal((Object)(_resolveBinding = (_type = creation.getType()).resolveBinding()), null));
            if (_and_1) {
                boolean _notEquals_2;
                IMethodBinding methodBinding = ((MethodDeclaration)declaredMethod).resolveBinding();
                boolean bl2 = _notEquals_2 = !Objects.equal((Object)methodBinding, null);
                if (_notEquals_2) {
                    boolean _notEquals_3;
                    ITypeBinding _declaringClass = methodBinding.getDeclaringClass();
                    IMethodBinding overrides = this.findOverride(methodBinding, _declaringClass, true);
                    boolean _and_2 = false;
                    boolean bl3 = _notEquals_3 = !Objects.equal((Object)overrides, null);
                    if (!_notEquals_3) {
                        _and_2 = false;
                    } else {
                        boolean _isAbstract;
                        int _modifiers = overrides.getModifiers();
                        _and_2 = _isAbstract = Modifier.isAbstract((int)_modifiers);
                    }
                    return _and_2;
                }
            }
        }
        return false;
    }

    public boolean needsReturnValue(ASTNode node) {
        boolean _notEquals;
        boolean _and = false;
        ASTNode _parent = node.getParent();
        boolean bl = _notEquals = !Objects.equal((Object)_parent, null);
        _and = !_notEquals ? false : !(node.getParent() instanceof Statement) || node.getParent() instanceof ReturnStatement;
        return _and;
    }

    public boolean isConstantArrayIndex(Expression node) {
        return node instanceof NumberLiteral;
    }

    public boolean canConvertToRichText(InfixExpression node) {
        boolean _not;
        boolean _notEquals;
        FieldDeclaration parentFieldDecl = this.findParentOfType((ASTNode)node, FieldDeclaration.class);
        boolean bl = _notEquals = !Objects.equal((Object)parentFieldDecl, null);
        if (_notEquals) {
            TypeDeclaration typeDeclr = this.findParentOfType((ASTNode)parentFieldDecl, TypeDeclaration.class);
            boolean _or = false;
            boolean _isInterface = typeDeclr.isInterface();
            if (_isInterface) {
                _or = true;
            } else {
                boolean _and = false;
                List _modifiers = parentFieldDecl.modifiers();
                boolean _isFinal = this.isFinal(_modifiers);
                if (!_isFinal) {
                    _and = false;
                } else {
                    boolean _isStatic;
                    List _modifiers_1 = parentFieldDecl.modifiers();
                    _and = _isStatic = this.isStatic(_modifiers_1);
                }
                _or = _and;
            }
            if (_or) {
                return false;
            }
        }
        Iterable<StringLiteral> nodes = this.collectCompatibleNodes(node);
        boolean _and_1 = false;
        boolean _isEmpty = IterableExtensions.isEmpty(nodes);
        boolean bl2 = _not = !_isEmpty;
        if (!_not) {
            _and_1 = false;
        } else {
            boolean _forall;
            Functions.Function1<StringLiteral, Boolean> _function = new Functions.Function1<StringLiteral, Boolean>(){

                public Boolean apply(StringLiteral it) {
                    return ASTFlattenerUtils.this.canTranslate(it);
                }
            };
            _and_1 = _forall = IterableExtensions.forall(nodes, (Functions.Function1)_function);
        }
        return _and_1;
    }

    public <T extends ASTNode> T findParentOfType(ASTNode someNode, Class<T> parentType) {
        ASTNode _parent = someNode.getParent();
        boolean _equals = Objects.equal((Object)_parent, null);
        if (_equals) {
            return null;
        }
        ASTNode _parent_1 = someNode.getParent();
        boolean _isInstance = parentType.isInstance(_parent_1);
        if (_isInstance) {
            ASTNode _parent_2 = someNode.getParent();
            return (T)((ASTNode)parentType.cast(_parent_2));
        }
        ASTNode _parent_3 = someNode.getParent();
        return this.findParentOfType(_parent_3, parentType);
    }

    private Iterable<StringLiteral> collectCompatibleNodes(InfixExpression node) {
        boolean _notEquals;
        ArrayList strings = CollectionLiterals.newArrayList((Object[])new StringLiteral[0]);
        InfixExpression.Operator _operator = node.getOperator();
        boolean bl = _notEquals = !Objects.equal((Object)_operator, (Object)InfixExpression.Operator.PLUS);
        if (_notEquals) {
            return strings;
        }
        Expression left = node.getLeftOperand();
        if (left instanceof StringLiteral) {
            strings.add((StringLiteral)left);
        } else if (left instanceof InfixExpression) {
            Iterable<StringLiteral> _collectCompatibleNodes = this.collectCompatibleNodes((InfixExpression)left);
            Iterables.addAll((Collection)strings, _collectCompatibleNodes);
        }
        Expression right = node.getRightOperand();
        if (right instanceof StringLiteral) {
            strings.add((StringLiteral)right);
        } else if (right instanceof InfixExpression) {
            Iterable<StringLiteral> _collectCompatibleNodes_1 = this.collectCompatibleNodes((InfixExpression)right);
            Iterables.addAll((Collection)strings, _collectCompatibleNodes_1);
        }
        List _extendedOperands = node.extendedOperands();
        Iterable _filter = Iterables.filter((Iterable)_extendedOperands, StringLiteral.class);
        Iterables.addAll((Collection)strings, (Iterable)_filter);
        return strings;
    }

    private boolean canTranslate(StringLiteral literal) {
        boolean _contains_2;
        boolean _contains_1;
        String value = literal.getEscapedValue();
        boolean _or = false;
        boolean _or_1 = false;
        boolean _contains = value.contains("\u00ab");
        _or_1 = _contains ? true : (_contains_1 = value.contains("\u00bb"));
        _or = _or_1 ? true : (_contains_2 = value.contains("'''"));
        return !_or;
    }

    public Type findDeclaredType(SimpleName simpleName) {
        Block scope = this.findParentOfType((ASTNode)simpleName, Block.class);
        while (!Objects.equal((Object)scope, null)) {
            Block _findParentOfType;
            boolean _notEquals;
            Type type = this.findDeclaredType(scope, simpleName);
            boolean bl = _notEquals = !Objects.equal((Object)type, null);
            if (_notEquals) {
                return type;
            }
            scope = _findParentOfType = this.findParentOfType((ASTNode)scope, Block.class);
        }
        return null;
    }

    private Type findDeclaredType(Block scope, final SimpleName simpleName) {
        final ArrayList matchesFound = CollectionLiterals.newArrayList((Object[])new Type[0]);
        scope.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationFragment node) {
                String _identifier_1;
                SimpleName _name = node.getName();
                String _identifier = _name.getIdentifier();
                boolean _equals = _identifier.equals(_identifier_1 = simpleName.getIdentifier());
                if (_equals) {
                    Type _type;
                    ASTNode parentNode = node.getParent();
                    boolean _matched = false;
                    if (!_matched && parentNode instanceof VariableDeclarationStatement) {
                        _matched = true;
                        _type = ((VariableDeclarationStatement)parentNode).getType();
                        matchesFound.add(_type);
                    }
                    if (!_matched && parentNode instanceof FieldDeclaration) {
                        _matched = true;
                        _type = ((FieldDeclaration)parentNode).getType();
                        matchesFound.add(_type);
                    }
                    if (!_matched && parentNode instanceof VariableDeclarationExpression) {
                        _matched = true;
                        _type = ((VariableDeclarationExpression)parentNode).getType();
                        matchesFound.add(_type);
                    }
                }
                return false;
            }

            public boolean preVisit2(ASTNode node) {
                return matchesFound.isEmpty();
            }

            public boolean visit(SingleVariableDeclaration node) {
                SimpleName _name = node.getName();
                boolean _equals = _name.equals((Object)simpleName);
                if (_equals) {
                    Type _type = node.getType();
                    matchesFound.add(_type);
                }
                return false;
            }
        });
        return (Type)IterableExtensions.head((Iterable)matchesFound);
    }

    private Iterable<Assignment> findAssigmentsInBlock(Block scope, final Functions.Function1<? super Assignment, ? extends Boolean> constraint) {
        boolean _notEquals;
        final HashSet assigments = CollectionLiterals.newHashSet((Object[])new Assignment[0]);
        boolean bl = _notEquals = !Objects.equal((Object)scope, null);
        if (_notEquals) {
            scope.accept(new ASTVisitor(){

                public boolean visit(Assignment node) {
                    Boolean _apply = (Boolean)constraint.apply((Object)node);
                    if (_apply.booleanValue()) {
                        assigments.add(node);
                    }
                    return true;
                }
            });
        }
        return assigments;
    }

    public Boolean isAssignedInBody(Block scope, final VariableDeclarationFragment fieldDeclFragment) {
        Functions.Function1<Assignment, Boolean> _function = new Functions.Function1<Assignment, Boolean>(){

            public Boolean apply(Assignment it) {
                Expression _leftHandSide_1;
                Name simpleName;
                IBinding binding;
                Expression _leftHandSide = it.getLeftHandSide();
                if (_leftHandSide instanceof Name && (binding = (simpleName = (Name)(_leftHandSide_1 = it.getLeftHandSide())).resolveBinding()) instanceof IVariableBinding) {
                    boolean _and = false;
                    boolean _isField = ((IVariableBinding)binding).isField();
                    if (!_isField) {
                        _and = false;
                    } else {
                        boolean _equals;
                        SimpleName _name = fieldDeclFragment.getName();
                        String _identifier = _name.getIdentifier();
                        String _simpleName = ASTFlattenerUtils.this.toSimpleName(simpleName);
                        _and = _equals = _identifier.equals(_simpleName);
                    }
                    return _and;
                }
                return false;
            }
        };
        Iterable<Assignment> _findAssigmentsInBlock = this.findAssigmentsInBlock(scope, (Functions.Function1<? super Assignment, ? extends Boolean>)_function);
        boolean _isEmpty = IterableExtensions.isEmpty(_findAssigmentsInBlock);
        return !_isEmpty;
    }

    public Boolean isAssignedInBody(Block scope, final SimpleName nameToLookFor) {
        Functions.Function1<Assignment, Boolean> _function = new Functions.Function1<Assignment, Boolean>(){

            public Boolean apply(Assignment it) {
                Expression _leftHandSide = it.getLeftHandSide();
                if (_leftHandSide instanceof SimpleName) {
                    String _identifier = nameToLookFor.getIdentifier();
                    Expression _leftHandSide_1 = it.getLeftHandSide();
                    String _identifier_1 = ((SimpleName)_leftHandSide_1).getIdentifier();
                    return _identifier.equals(_identifier_1);
                }
                return false;
            }
        };
        Iterable<Assignment> _findAssigmentsInBlock = this.findAssigmentsInBlock(scope, (Functions.Function1<? super Assignment, ? extends Boolean>)_function);
        boolean _isEmpty = IterableExtensions.isEmpty(_findAssigmentsInBlock);
        return !_isEmpty;
    }

    protected String _toSimpleName(SimpleName name) {
        return name.getIdentifier();
    }

    protected String _toSimpleName(QualifiedName name) {
        SimpleName _name = name.getName();
        return _name.getIdentifier();
    }

    public String toSimpleName(Name name) {
        if (name instanceof QualifiedName) {
            return this._toSimpleName((QualifiedName)name);
        }
        if (name instanceof SimpleName) {
            return this._toSimpleName((SimpleName)name);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(name).toString());
    }
}

