/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import org.eclipse.jface.text.IMarkRegionTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.graphics.Point;

public class MarkRegionTargetWithoutStatusline
implements IMarkRegionTarget {
    private final ITextViewer fViewer;

    public MarkRegionTargetWithoutStatusline(ITextViewer viewer) {
        this.fViewer = viewer;
    }

    public void setMarkAtCursor(boolean set) {
        if (!(this.fViewer instanceof ITextViewerExtension)) {
            return;
        }
        ITextViewerExtension viewerExtension = (ITextViewerExtension)this.fViewer;
        if (set) {
            Point selection = this.fViewer.getSelectedRange();
            viewerExtension.setMark(selection.x);
        } else {
            viewerExtension.setMark(-1);
        }
    }

    public void swapMarkAndCursor() {
        if (!(this.fViewer instanceof ITextViewerExtension)) {
            return;
        }
        ITextViewerExtension viewerExtension = (ITextViewerExtension)this.fViewer;
        int markPosition = viewerExtension.getMark();
        if (markPosition == -1) {
            return;
        }
        if (!this.isVisible(this.fViewer, markPosition)) {
            return;
        }
        Point selection = this.fViewer.getSelectedRange();
        viewerExtension.setMark(selection.x);
        this.fViewer.setSelectedRange(markPosition, 0);
        this.fViewer.revealRange(markPosition, 0);
    }

    protected boolean isVisible(ITextViewer viewer, int offset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.modelOffset2WidgetOffset(offset) >= 0;
        }
        IRegion region = viewer.getVisibleRegion();
        int vOffset = region.getOffset();
        return vOffset <= offset && offset <= vOffset + region.getLength();
    }
}

