/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import org.eclipse.lsp4j.Range;
import org.eclipse.xtext.ide.util.PositionComparator;

@Singleton
public class RangeComparator
implements Comparator<Range> {
    private final Comparator<Range> delegate;

    @Inject
    public RangeComparator(PositionComparator positionComparator) {
        Preconditions.checkNotNull((Object)positionComparator, (Object)"positionComparator");
        this.delegate = (left, right) -> ComparisonChain.start().compare((Object)left.getStart(), (Object)right.getStart(), (Comparator)positionComparator).compare((Object)left.getEnd(), (Object)right.getEnd(), (Comparator)positionComparator).result();
    }

    @Override
    public int compare(Range left, Range right) {
        return Ordering.from(this.delegate).nullsLast().compare((Object)left, (Object)right);
    }
}

