/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.xtend.core.javaconverter.ASTParserFactory;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

public class JavaCodeAnalyzer {
    @Inject
    private ASTParserFactory parserFactory;

    public JavaParseResult<? extends ASTNode> determinateJavaType(String javaCode) {
        boolean _greaterThan;
        this.parserFactory.getClass();
        ASTParser parser = this.parserFactory.createDefaultJavaParser("1.6");
        parser.setSource(javaCode.toCharArray());
        parser.setStatementsRecovery(true);
        ASTNode _createAST = parser.createAST(null);
        CompilationUnit unit = (CompilationUnit)_createAST;
        int _size = unit.types().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            List<CompilationUnit> _singletonList = Collections.singletonList(unit);
            return new JavaParseResult<CompilationUnit>(javaCode, 8, _singletonList);
        }
        parser.setSource(javaCode.toCharArray());
        parser.setStatementsRecovery(false);
        parser.setKind(4);
        ASTNode root = parser.createAST(null);
        if (root instanceof TypeDeclaration) {
            boolean _greaterThan_1;
            List bodyDeclarations = ((TypeDeclaration)root).bodyDeclarations();
            int _size_1 = bodyDeclarations.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                return new JavaParseResult(javaCode, 4, bodyDeclarations);
            }
        }
        parser.setSource(javaCode.toCharArray());
        parser.setStatementsRecovery(false);
        parser.setKind(2);
        root = parser.createAST(null);
        if (root instanceof Block) {
            boolean _greaterThan_2;
            List statements = ((Block)root).statements();
            int _size_2 = statements.size();
            boolean bl3 = _greaterThan_2 = _size_2 > 0;
            if (_greaterThan_2) {
                return new JavaParseResult(javaCode, 2, statements);
            }
        }
        parser.setSource(javaCode.toCharArray());
        parser.setStatementsRecovery(false);
        parser.setKind(1);
        root = parser.createAST(null);
        if (root instanceof Expression) {
            List<Expression> _singletonList_1 = Collections.singletonList((Expression)root);
            return new JavaParseResult<Expression>(javaCode, 1, _singletonList_1);
        }
        return null;
    }

    @Accessors(value={AccessorType.PUBLIC_GETTER})
    public static final class JavaParseResult<T extends ASTNode> {
        private String javaCode;
        private List<T> nodes;
        private int type;

        public JavaParseResult(String javaCode, int type, List<T> nodes) {
            this.javaCode = javaCode;
            this.type = type;
            this.nodes = nodes;
        }

        @Pure
        public String getJavaCode() {
            return this.javaCode;
        }

        @Pure
        public List<T> getNodes() {
            return this.nodes;
        }

        @Pure
        public int getType() {
            return this.type;
        }
    }
}

