/*******************************************************************************
 * Copyright (c) 2010-2016 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.xtend.core.parser.antlr.internal;

import static org.eclipse.xtend.core.parser.antlr.internal.InternalXtendParser.*;

import org.antlr.runtime.Token;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.TokenSource;

@SuppressWarnings({"all"})

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * from the specification file
 * <tt>../org.eclipse.xtend.core/src-gen/org/eclipse/xtend/core/parser/antlr/internal/InternalXtendFlexer.flex</tt>
 */
class InternalXtendFlexer implements org.eclipse.xtend.core.parser.InternalFlexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\1\1\2\2\0\1\14\16\5\4\0\1\1\1\34\1\31"+
    "\1\27\1\4\1\36\1\37\1\30\1\40\1\41\1\13\1\42\1\43"+
    "\1\22\1\45\1\12\1\25\11\11\1\47\1\50\1\46\1\35\1\44"+
    "\1\51\1\52\1\53\1\60\1\10\1\66\1\56\1\54\2\4\1\64"+
    "\2\4\1\62\1\4\1\65\1\61\1\67\1\4\1\57\1\63\1\55"+
    "\3\4\1\26\2\4\1\70\1\6\1\71\1\3\1\15\1\0\1\72"+
    "\1\17\1\76\1\21\1\16\1\24\1\111\1\101\1\20\1\4\1\110"+
    "\1\23\1\103\1\77\1\100\1\102\1\4\1\75\1\73\1\74\1\7"+
    "\1\106\1\107\1\104\1\105\1\112\1\113\1\114\1\115\1\0\41\5"+
    "\2\0\4\4\4\0\1\4\1\33\1\0\1\5\7\0\1\4\4\0"+
    "\1\4\1\32\4\0\27\4\1\0\37\4\1\0\u01ca\4\4\0\14\4"+
    "\16\0\5\4\7\0\1\4\1\0\1\4\21\0\160\5\5\4\1\0"+
    "\2\4\2\0\4\4\10\0\1\4\1\0\3\4\1\0\1\4\1\0"+
    "\24\4\1\0\123\4\1\0\213\4\1\0\5\5\2\0\236\4\11\0"+
    "\46\4\2\0\1\4\7\0\47\4\7\0\1\4\1\0\55\5\1\0"+
    "\1\5\1\0\2\5\1\0\2\5\1\0\1\5\10\0\33\4\5\0"+
    "\3\4\15\0\5\5\6\0\1\4\4\0\13\5\5\0\53\4\37\5"+
    "\4\0\2\4\1\5\143\4\1\0\1\4\10\5\1\0\6\5\2\4"+
    "\2\5\1\0\4\5\2\4\12\5\3\4\2\0\1\4\17\0\1\5"+
    "\1\4\1\5\36\4\33\5\2\0\131\4\13\5\1\4\16\0\12\5"+
    "\41\4\11\5\2\4\4\0\1\4\5\0\26\4\4\5\1\4\11\5"+
    "\1\4\3\5\1\4\5\5\22\0\31\4\3\5\104\0\1\4\1\0"+
    "\13\4\67\0\33\5\1\0\4\5\66\4\3\5\1\4\22\5\1\4"+
    "\7\5\12\4\2\5\2\0\12\5\1\0\7\4\1\0\7\4\1\0"+
    "\3\5\1\0\10\4\2\0\2\4\2\0\26\4\1\0\7\4\1\0"+
    "\1\4\3\0\4\4\2\0\1\5\1\4\7\5\2\0\2\5\2\0"+
    "\3\5\1\4\10\0\1\5\4\0\2\4\1\0\3\4\2\5\2\0"+
    "\12\5\4\4\7\0\1\4\5\0\3\5\1\0\6\4\4\0\2\4"+
    "\2\0\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4"+
    "\2\0\1\5\1\0\5\5\4\0\2\5\2\0\3\5\3\0\1\5"+
    "\7\0\4\4\1\0\1\4\7\0\14\5\3\4\1\5\13\0\3\5"+
    "\1\0\11\4\1\0\3\4\1\0\26\4\1\0\7\4\1\0\2\4"+
    "\1\0\5\4\2\0\1\5\1\4\10\5\1\0\3\5\1\0\3\5"+
    "\2\0\1\4\17\0\2\4\2\5\2\0\12\5\1\0\1\4\17\0"+
    "\3\5\1\0\10\4\2\0\2\4\2\0\26\4\1\0\7\4\1\0"+
    "\2\4\1\0\5\4\2\0\1\5\1\4\7\5\2\0\2\5\2\0"+
    "\3\5\10\0\2\5\4\0\2\4\1\0\3\4\2\5\2\0\12\5"+
    "\1\0\1\4\20\0\1\5\1\4\1\0\6\4\3\0\3\4\1\0"+
    "\4\4\3\0\2\4\1\0\1\4\1\0\2\4\3\0\2\4\3\0"+
    "\3\4\3\0\14\4\4\0\5\5\3\0\3\5\1\0\4\5\2\0"+
    "\1\4\6\0\1\5\16\0\12\5\11\0\1\4\7\0\3\5\1\0"+
    "\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4\3\0"+
    "\1\4\7\5\1\0\3\5\1\0\4\5\7\0\2\5\1\0\2\4"+
    "\6\0\2\4\2\5\2\0\12\5\22\0\2\5\1\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\12\4\1\0\5\4\2\0\1\5\1\4"+
    "\7\5\1\0\3\5\1\0\4\5\7\0\2\5\7\0\1\4\1\0"+
    "\2\4\2\5\2\0\12\5\1\0\2\4\17\0\2\5\1\0\10\4"+
    "\1\0\3\4\1\0\51\4\2\0\1\4\7\5\1\0\3\5\1\0"+
    "\4\5\1\4\10\0\1\5\10\0\2\4\2\5\2\0\12\5\12\0"+
    "\6\4\2\0\2\5\1\0\22\4\3\0\30\4\1\0\11\4\1\0"+
    "\1\4\2\0\7\4\3\0\1\5\4\0\6\5\1\0\1\5\1\0"+
    "\10\5\22\0\2\5\15\0\60\4\1\5\2\4\7\5\4\0\10\4"+
    "\10\5\1\0\12\5\47\0\2\4\1\0\1\4\2\0\2\4\1\0"+
    "\1\4\2\0\1\4\6\0\4\4\1\0\7\4\1\0\3\4\1\0"+
    "\1\4\1\0\1\4\2\0\2\4\1\0\4\4\1\5\2\4\6\5"+
    "\1\0\2\5\1\4\2\0\5\4\1\0\1\4\1\0\6\5\2\0"+
    "\12\5\2\0\4\4\40\0\1\4\27\0\2\5\6\0\12\5\13\0"+
    "\1\5\1\0\1\5\1\0\1\5\4\0\2\5\10\4\1\0\44\4"+
    "\4\0\24\5\1\0\2\5\5\4\13\5\1\0\44\5\11\0\1\5"+
    "\71\0\53\4\24\5\1\4\12\5\6\0\6\4\4\5\4\4\3\5"+
    "\1\4\3\5\2\4\7\5\3\4\4\5\15\4\14\5\1\4\17\5"+
    "\2\0\46\4\1\0\1\4\5\0\1\4\2\0\53\4\1\0\u014d\4"+
    "\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4\2\0\51\4"+
    "\1\0\4\4\2\0\41\4\1\0\4\4\2\0\7\4\1\0\1\4"+
    "\1\0\4\4\2\0\17\4\1\0\71\4\1\0\4\4\2\0\103\4"+
    "\2\0\3\5\40\0\20\4\20\0\125\4\14\0\u026c\4\2\0\21\4"+
    "\1\0\32\4\5\0\113\4\3\0\3\4\17\0\15\4\1\0\4\4"+
    "\3\5\13\0\22\4\3\5\13\0\22\4\2\5\14\0\15\4\1\0"+
    "\3\4\1\0\2\5\14\0\64\4\40\5\3\0\1\4\3\0\2\4"+
    "\1\5\2\0\12\5\41\0\3\5\2\0\12\5\6\0\130\4\10\0"+
    "\51\4\1\5\1\4\5\0\106\4\12\0\35\4\3\0\14\5\4\0"+
    "\14\5\12\0\12\5\36\4\2\0\5\4\13\0\54\4\4\0\21\5"+
    "\7\4\2\5\6\0\12\5\46\0\27\4\5\5\4\0\65\4\12\5"+
    "\1\0\35\5\2\0\13\5\6\0\12\5\15\0\1\4\130\0\5\5"+
    "\57\4\21\5\7\4\4\0\12\5\21\0\11\5\14\0\3\5\36\4"+
    "\15\5\2\4\12\5\54\4\16\5\14\0\44\4\24\5\10\0\12\5"+
    "\3\0\3\4\12\5\44\4\122\0\3\5\1\0\25\5\4\4\1\5"+
    "\4\4\3\5\2\4\11\0\300\4\47\5\25\0\4\5\u0116\4\2\0"+
    "\6\4\2\0\46\4\2\0\6\4\2\0\10\4\1\0\1\4\1\0"+
    "\1\4\1\0\1\4\1\0\37\4\2\0\65\4\1\0\7\4\1\0"+
    "\1\4\3\0\3\4\1\0\7\4\3\0\4\4\2\0\6\4\4\0"+
    "\15\4\5\0\3\4\1\0\7\4\16\0\5\5\32\0\5\5\20\0"+
    "\2\4\23\0\1\4\13\0\5\5\5\0\6\5\1\0\1\4\15\0"+
    "\1\4\20\0\15\4\3\0\33\4\25\0\15\5\4\0\1\5\3\0"+
    "\14\5\21\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4\3\0"+
    "\5\4\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4\1\0"+
    "\13\4\2\0\4\4\5\0\5\4\4\0\1\4\21\0\51\4\u0a77\0"+
    "\57\4\1\0\57\4\1\0\205\4\6\0\4\4\3\5\2\4\14\0"+
    "\46\4\1\0\1\4\5\0\1\4\2\0\70\4\7\0\1\4\17\0"+
    "\1\5\27\4\11\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4"+
    "\1\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0\40\5"+
    "\57\0\1\4\u01d5\0\3\4\31\0\11\4\6\5\1\0\5\4\2\0"+
    "\5\4\4\0\126\4\2\0\2\5\2\0\3\4\1\0\132\4\1\0"+
    "\4\4\5\0\51\4\3\0\136\4\21\0\33\4\65\0\20\4\u0200\0"+
    "\u19b6\4\112\0\u51cd\4\63\0\u048d\4\103\0\56\4\2\0\u010d\4\3\0"+
    "\20\4\12\5\2\4\24\0\57\4\1\5\4\0\12\5\1\0\31\4"+
    "\7\0\1\5\120\4\2\5\45\0\11\4\2\0\147\4\2\0\4\4"+
    "\1\0\4\4\14\0\13\4\115\0\12\4\1\5\3\4\1\5\4\4"+
    "\1\5\27\4\5\5\20\0\1\4\7\0\64\4\14\0\2\5\62\4"+
    "\21\5\13\0\12\5\6\0\22\5\6\4\3\0\1\4\4\0\12\5"+
    "\34\4\10\5\2\0\27\4\15\5\14\0\35\4\3\0\4\5\57\4"+
    "\16\5\16\0\1\4\12\5\46\0\51\4\16\5\11\0\3\4\1\5"+
    "\10\4\2\5\2\0\12\5\6\0\27\4\3\0\1\4\1\5\4\0"+
    "\60\4\1\5\1\4\3\5\2\4\2\5\5\4\2\5\1\4\1\5"+
    "\1\4\30\0\3\4\2\0\13\4\5\5\2\0\3\4\2\5\12\0"+
    "\6\4\2\0\6\4\2\0\6\4\11\0\7\4\1\0\7\4\221\0"+
    "\43\4\10\5\1\0\2\5\2\0\12\5\6\0\u2ba4\4\14\0\27\4"+
    "\4\0\61\4\u2104\0\u016e\4\2\0\152\4\46\0\7\4\14\0\5\4"+
    "\5\0\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4"+
    "\1\0\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4"+
    "\2\0\66\4\50\0\15\4\3\0\20\5\20\0\7\5\14\0\2\4"+
    "\30\0\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5"+
    "\4\0\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4"+
    "\13\0\131\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4"+
    "\3\0\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\1\1\3\1\1\1\4\1\5"+
    "\1\6\3\3\1\7\1\3\1\4\1\10\2\11\1\12"+
    "\1\1\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\6\3\1\32\1\33\12\3\1\34\1\35\1\36\3\0"+
    "\1\37\1\40\1\41\1\42\1\43\1\44\3\3\1\45"+
    "\4\3\1\46\1\47\1\50\1\51\3\3\1\52\1\11"+
    "\1\0\1\11\1\0\1\11\1\12\1\53\1\0\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\6\3\1\71\1\3\1\72"+
    "\26\3\1\73\1\41\1\37\2\41\1\40\1\0\1\41"+
    "\6\3\1\74\3\3\1\75\1\52\1\76\1\12\1\77"+
    "\1\0\1\100\1\101\1\102\1\103\1\3\1\104\15\3"+
    "\1\105\10\3\1\106\6\3\1\107\1\110\2\3\2\0"+
    "\1\111\1\0\1\112\1\113\11\3\1\0\1\76\1\114"+
    "\1\12\1\77\1\115\1\3\1\116\13\3\1\117\5\3"+
    "\1\120\2\3\1\121\17\3\1\122\1\123\1\0\1\52"+
    "\1\76\1\77\1\124\2\3\1\125\4\3\1\126\5\3"+
    "\1\127\2\3\1\130\1\131\10\3\1\132\5\3\1\133"+
    "\3\3\1\76\1\77\1\134\1\135\1\136\3\3\1\137"+
    "\2\3\1\140\1\3\1\141\1\142\1\143\1\144\1\145"+
    "\1\3\1\146\4\3\1\147\4\3\1\150\1\3\1\151"+
    "\7\3\1\152\1\153\6\3\1\154\1\3\1\155\1\3"+
    "\1\156\2\3\1\157\1\3\1\160\1\161\1\3\1\162"+
    "\1\3\1\163\2\3\1\164\1\165\1\166\1\167\1\170"+
    "\2\3\1\171";

  private static int [] zzUnpackAction() {
    int [] result = new int[370];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\116\0\234\0\352\0\u0138\0\u0186\0\u01d4\0\u0222"+
    "\0\u0270\0\u02be\0\u030c\0\u035a\0\u03a8\0\u03f6\0\u0444\0\116"+
    "\0\u0492\0\u04e0\0\u052e\0\u057c\0\u05ca\0\u0618\0\u0666\0\u06b4"+
    "\0\116\0\116\0\u0702\0\116\0\u0750\0\u079e\0\u07ec\0\u083a"+
    "\0\116\0\u0888\0\116\0\u08d6\0\u0924\0\u0972\0\u09c0\0\u0a0e"+
    "\0\u0a5c\0\116\0\116\0\u0aaa\0\u0af8\0\u0b46\0\u0b94\0\u0be2"+
    "\0\u0c30\0\u0c7e\0\u0ccc\0\u0d1a\0\u0d68\0\116\0\u0db6\0\116"+
    "\0\u0186\0\u0e04\0\u0e52\0\116\0\u0ea0\0\u0eee\0\116\0\116"+
    "\0\116\0\u0f3c\0\u0f8a\0\u0fd8\0\u0138\0\u1026\0\u1074\0\u10c2"+
    "\0\u1110\0\u0138\0\116\0\116\0\116\0\u115e\0\u11ac\0\u11fa"+
    "\0\u1248\0\u1296\0\u12e4\0\u1332\0\u1380\0\116\0\u13ce\0\116"+
    "\0\u141c\0\u146a\0\u14b8\0\116\0\116\0\116\0\116\0\116"+
    "\0\116\0\u1506\0\116\0\116\0\116\0\116\0\u1554\0\u15a2"+
    "\0\u15f0\0\u163e\0\u168c\0\u16da\0\u0138\0\u1728\0\u0138\0\u1776"+
    "\0\u17c4\0\u1812\0\u1860\0\u18ae\0\u18fc\0\u194a\0\u1998\0\u19e6"+
    "\0\u1a34\0\u1a82\0\u1ad0\0\u1b1e\0\u1b6c\0\u1bba\0\u1c08\0\u1c56"+
    "\0\u1ca4\0\u1cf2\0\u1d40\0\u1d8e\0\u1ddc\0\116\0\u1e2a\0\u1e78"+
    "\0\u1ec6\0\116\0\116\0\u1f14\0\u1f62\0\u1fb0\0\u1ffe\0\u204c"+
    "\0\u209a\0\u20e8\0\u2136\0\u2184\0\u21d2\0\u2220\0\u226e\0\u0138"+
    "\0\u22bc\0\u230a\0\u2358\0\u23a6\0\u23f4\0\116\0\116\0\116"+
    "\0\116\0\u2442\0\u0138\0\u2490\0\u24de\0\u252c\0\u257a\0\u25c8"+
    "\0\u2616\0\u2664\0\u26b2\0\u2700\0\u274e\0\u279c\0\u27ea\0\u2838"+
    "\0\u0138\0\u2886\0\u28d4\0\u2922\0\u2970\0\u29be\0\u2a0c\0\u2a5a"+
    "\0\u2aa8\0\u0138\0\u2af6\0\u2b44\0\u2b92\0\u2be0\0\u2c2e\0\u2c7c"+
    "\0\u0138\0\u0138\0\u2cca\0\u2d18\0\u2d66\0\u2db4\0\116\0\u1f62"+
    "\0\u0138\0\u0138\0\u2e02\0\u2e50\0\u2e9e\0\u2eec\0\u2f3a\0\u2f88"+
    "\0\u2fd6\0\u3024\0\u3072\0\u30c0\0\u310e\0\116\0\116\0\u315c"+
    "\0\116\0\u31aa\0\u31f8\0\u3246\0\u3294\0\u32e2\0\u3330\0\u337e"+
    "\0\u33cc\0\u341a\0\u3468\0\u34b6\0\u3504\0\u3552\0\u0138\0\u35a0"+
    "\0\u35ee\0\u363c\0\u368a\0\u36d8\0\u0138\0\u3726\0\u3774\0\u0138"+
    "\0\u37c2\0\u3810\0\u385e\0\u38ac\0\u38fa\0\u3948\0\u3996\0\u39e4"+
    "\0\u3a32\0\u3a80\0\u3ace\0\u3b1c\0\u3b6a\0\u3bb8\0\u3c06\0\u3c54"+
    "\0\u0138\0\u3ca2\0\116\0\u3cf0\0\u3d3e\0\u0138\0\u3d8c\0\u3dda"+
    "\0\u0138\0\u3e28\0\u3e76\0\u3ec4\0\u3f12\0\u0138\0\u3f60\0\u3fae"+
    "\0\u3ffc\0\u404a\0\u4098\0\u40e6\0\u4134\0\u4182\0\u0138\0\u0138"+
    "\0\u41d0\0\u421e\0\u426c\0\u42ba\0\u4308\0\u4356\0\u43a4\0\u43f2"+
    "\0\u0138\0\u4440\0\u448e\0\u44dc\0\u452a\0\u4578\0\u0138\0\u45c6"+
    "\0\u4614\0\u4662\0\116\0\116\0\u0138\0\u0138\0\u0138\0\u46b0"+
    "\0\u46fe\0\u474c\0\u0138\0\u479a\0\u47e8\0\u0138\0\u4836\0\u0138"+
    "\0\u0138\0\u0138\0\u0138\0\u0138\0\u4884\0\u0138\0\u48d2\0\u4920"+
    "\0\u496e\0\u49bc\0\u0138\0\u4a0a\0\u4a58\0\u4aa6\0\u4af4\0\u0138"+
    "\0\u4b42\0\u0138\0\u4b90\0\u4bde\0\u4c2c\0\u4c7a\0\u4cc8\0\u4d16"+
    "\0\u4d64\0\u0138\0\u0138\0\u4db2\0\u4e00\0\u4e4e\0\u4e9c\0\u4eea"+
    "\0\u4f38\0\u0138\0\u4f86\0\u0138\0\u4fd4\0\u0138\0\u5022\0\u5070"+
    "\0\u0138\0\u50be\0\u0138\0\u0138\0\u510c\0\u0138\0\u515a\0\u0138"+
    "\0\u51a8\0\u51f6\0\u0138\0\u0138\0\u0138\0\u0138\0\u0138\0\u5244"+
    "\0\u5292\0\u0138";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[370];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\2\3\1\4\1\5\1\2\1\6\2\5\1\7"+
    "\1\10\1\11\1\3\1\5\1\12\1\5\1\13\1\14"+
    "\1\15\1\5\1\16\1\17\1\5\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\1\5\1\46\1\5\1\47\2\5"+
    "\1\50\1\51\3\5\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\1\60\1\61\1\62\1\5\1\63\3\5\1\64"+
    "\1\65\3\5\1\66\1\67\1\70\117\0\2\3\11\0"+
    "\1\3\105\0\1\5\1\0\1\71\2\5\4\0\5\5"+
    "\1\0\2\5\1\0\1\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\12\0\1\5\117\0\1\7"+
    "\3\0\1\7\1\72\1\73\1\0\1\74\1\0\2\74"+
    "\1\7\26\0\1\74\1\0\1\72\1\0\1\73\1\0"+
    "\1\74\3\0\1\74\41\0\1\75\1\76\21\0\1\77"+
    "\73\0\1\100\21\0\1\101\64\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\1\102\3\5\24\0\15\5\2\0"+
    "\5\5\1\103\4\5\1\104\6\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\1\5\1\105\2\5\24\0"+
    "\15\5\2\0\5\5\1\106\3\5\1\107\7\5\7\0"+
    "\2\5\1\71\3\5\3\0\1\5\1\110\1\5\1\111"+
    "\1\5\1\0\4\5\24\0\15\5\2\0\6\5\1\112"+
    "\12\5\25\0\1\113\12\0\1\114\6\0\1\115\55\0"+
    "\2\5\1\71\3\5\3\0\3\5\1\116\1\5\1\0"+
    "\4\5\24\0\15\5\2\0\1\117\5\5\1\120\12\5"+
    "\14\0\1\7\3\0\1\7\1\72\1\73\1\0\1\74"+
    "\1\0\2\74\1\7\1\121\25\0\1\74\1\0\1\72"+
    "\1\0\1\73\1\0\1\74\3\0\1\74\15\0\1\121"+
    "\11\0\6\122\1\123\21\122\1\124\65\122\6\22\1\125"+
    "\22\22\1\126\64\22\30\23\1\127\2\23\1\130\62\23"+
    "\33\0\1\131\117\0\1\132\115\0\1\133\6\0\1\134"+
    "\106\0\1\135\117\0\1\136\113\0\1\137\4\0\1\140"+
    "\110\0\1\141\125\0\1\142\114\0\1\143\120\0\1\144"+
    "\113\0\1\145\1\0\1\146\52\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\1\5\1\147\13\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\6\5\1\150\6\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\7\5\1\151\2\5\1\152\2\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\3\5\1\153\11\5\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\3\5"+
    "\1\154\11\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\1\5\1\155\13\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\2\5"+
    "\1\156\2\5\1\0\4\5\24\0\15\5\2\0\1\5"+
    "\1\157\3\5\1\160\13\5\7\0\2\5\1\71\1\161"+
    "\2\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\2\5\1\162\10\5\1\163\1\5\1\164\3\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\3\5\1\165\3\5\1\166\3\5\1\167"+
    "\5\5\7\0\2\5\1\71\3\5\3\0\1\5\1\170"+
    "\3\5\1\0\4\5\24\0\15\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\1\171\3\5"+
    "\24\0\15\5\2\0\1\172\2\5\1\173\15\5\7\0"+
    "\2\5\1\71\1\174\2\5\3\0\1\5\1\175\3\5"+
    "\1\0\4\5\24\0\15\5\2\0\1\176\20\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\14\5\1\177\4\5\7\0\2\5\1\71"+
    "\1\200\2\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\1\201\2\5\1\202\15\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\1\203\5\5\1\204\12\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\7\5"+
    "\1\205\11\5\117\0\1\206\1\0\11\207\1\210\10\207"+
    "\1\211\2\207\1\210\14\207\1\211\53\207\20\212\2\74"+
    "\42\212\1\74\1\212\1\74\27\212\2\75\1\213\11\75"+
    "\1\214\101\75\13\76\1\215\102\76\4\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\1\5\1\216\17\5\7\0\2\5\1\71\1\217\2\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\2\5\1\220\16\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\1\5\1\221\1\222\16\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\10\5\1\223\10\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\1\5\1\224\2\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\1\5\1\225\17\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\5\5\1\226\13\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\1\227\3\5\24\0\15\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\3\5\1\230\15\5"+
    "\13\0\2\231\3\0\3\231\1\0\1\231\2\0\2\231"+
    "\25\0\2\231\1\0\1\231\1\0\1\231\5\0\1\231"+
    "\3\0\1\231\3\0\1\231\17\0\6\122\1\123\21\122"+
    "\1\126\67\122\1\0\113\122\30\0\1\232\65\0\2\22"+
    "\1\0\113\22\30\23\1\233\2\23\1\130\62\23\2\131"+
    "\1\234\11\131\1\235\101\131\35\0\1\236\115\0\1\237"+
    "\125\0\1\240\1\241\53\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\2\5\1\242\12\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\4\5\1\243\10\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\10\5\1\244\4\5\2\0\21\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\13\5\1\245"+
    "\1\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\1\5\1\246\13\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\14\5\1\247\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\1\5\1\250\17\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\5\5"+
    "\1\251\13\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\10\5\1\252\10\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\1\253\2\5\1\254\15\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\5\5\1\255\13\5\7\0\2\5\1\71"+
    "\3\5\3\0\3\5\1\256\1\5\1\0\4\5\24\0"+
    "\15\5\2\0\21\5\7\0\2\5\1\71\1\257\2\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\1\260"+
    "\12\5\1\261\5\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\3\5\1\262"+
    "\15\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\10\5\1\263\10\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\2\5\1\264\16\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\1\265\20\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\1\5\1\266\1\267"+
    "\16\5\7\0\2\5\1\71\3\5\3\0\1\5\1\270"+
    "\3\5\1\0\4\5\24\0\15\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\1\271\3\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\15\5"+
    "\1\272\3\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\2\5\1\273\16\5"+
    "\7\0\2\5\1\71\3\5\3\0\1\5\1\274\3\5"+
    "\1\0\4\5\24\0\15\5\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\2\5\1\275\2\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\4\5"+
    "\1\276\14\5\7\0\2\5\1\71\3\5\3\0\3\5"+
    "\1\277\1\5\1\0\4\5\24\0\15\5\2\0\6\5"+
    "\1\300\12\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\1\301\3\5\24\0\15\5\2\0\3\5\1\302"+
    "\15\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\1\303\3\5\24\0\15\5\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\3\5\1\304\1\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\22\0\1\305\40\0\1\305"+
    "\46\0\1\210\3\0\1\210\1\0\1\306\1\0\1\74"+
    "\1\0\2\74\1\210\26\0\1\74\3\0\1\306\1\0"+
    "\1\74\3\0\1\74\40\0\1\210\5\0\1\305\5\0"+
    "\1\210\32\0\1\305\37\0\1\213\113\0\12\76\1\307"+
    "\1\310\102\76\4\0\2\5\1\71\3\5\3\0\1\5"+
    "\1\311\3\5\1\0\4\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\11\5\1\312\7\5\7\0\2\5"+
    "\1\71\3\5\3\0\1\5\1\313\3\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\2\5"+
    "\1\314\16\5\7\0\2\5\1\71\3\5\3\0\1\5"+
    "\1\315\3\5\1\0\4\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\1\316"+
    "\3\5\24\0\15\5\2\0\6\5\1\317\12\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\1\320\20\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\10\5"+
    "\1\321\10\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\1\322\20\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\1\5\1\323\17\5\13\0\2\231\3\0"+
    "\3\231\1\0\1\231\2\0\2\231\1\0\1\324\23\0"+
    "\2\231\1\0\1\231\1\0\1\231\5\0\1\231\3\0"+
    "\1\231\3\0\1\231\17\0\30\232\1\325\2\232\1\326"+
    "\62\232\30\23\1\327\2\23\1\130\62\23\30\234\1\330"+
    "\2\234\1\331\62\234\2\0\1\234\117\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\3\5\1\332"+
    "\11\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\3\5\1\333\11\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\1\5\1\334\7\5\1\335\3\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\6\5\1\336\6\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\1\337\14\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\2\5"+
    "\1\340\16\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\6\5\1\341\12\5"+
    "\7\0\2\5\1\71\3\5\3\0\1\5\1\342\3\5"+
    "\1\0\4\5\24\0\15\5\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\2\5\1\343\16\5\7\0\2\5\1\71\3\5"+
    "\3\0\3\5\1\344\1\5\1\0\4\5\24\0\15\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\4\5\1\345\14\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\2\5\1\346\16\5\7\0\2\5"+
    "\1\71\3\5\3\0\1\5\1\347\3\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\5\5"+
    "\1\350\13\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\6\5\1\351\12\5"+
    "\7\0\2\5\1\71\3\5\3\0\1\5\1\352\3\5"+
    "\1\0\4\5\24\0\15\5\2\0\21\5\7\0\2\5"+
    "\1\71\1\353\2\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\1\5\1\354"+
    "\17\5\7\0\2\5\1\71\3\5\3\0\1\5\1\355"+
    "\3\5\1\0\4\5\24\0\15\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\4\5\1\356\14\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\1\357\20\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\1\360\3\5\24\0\15\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\3\5\1\361\1\5\1\0"+
    "\4\5\24\0\15\5\2\0\21\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\3\5\1\362\15\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\1\363\3\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\16\5\1\364\2\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\14\5\1\365\4\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\2\5"+
    "\1\366\16\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\1\367\20\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\1\370\3\5"+
    "\24\0\15\5\2\0\21\5\3\0\20\212\2\0\42\212"+
    "\1\0\1\212\1\0\27\212\20\0\2\74\42\0\1\74"+
    "\1\0\1\74\33\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\5\5\1\371\13\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\1\372\20\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\3\5\1\373\15\5\7\0\2\5\1\71\3\5\3\0"+
    "\1\5\1\374\3\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\3\5\1\375\15\5\7\0"+
    "\2\5\1\71\1\376\2\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\1\377"+
    "\20\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\1\u0100\3\5\24\0\15\5\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\1\5\1\u0101\3\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\22\0\1\u0102\3\0\1\u0103"+
    "\34\0\1\u0102\1\0\1\u0103\33\0\30\232\1\u0104\2\232"+
    "\1\326\62\232\30\234\1\u0105\2\234\1\331\62\234\4\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\4\5\1\u0106\10\5\2\0\21\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\11\5\1\u0107"+
    "\3\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\6\5\1\u0108\6\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\1\5\1\u0109\13\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\4\5\1\u010a\10\5\2\0\21\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\4\5\1\u010b"+
    "\10\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\3\5\1\u010c"+
    "\15\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\2\5\1\u010d\16\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\3\5\1\u010e\15\5\7\0\2\5\1\71"+
    "\3\5\3\0\3\5\1\u010f\1\5\1\0\4\5\24\0"+
    "\15\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\4\5\1\u0110"+
    "\14\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\7\5\1\u0111\11\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\4\5\1\u0112\14\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\1\5\1\u0113\17\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\15\5\1\u0114"+
    "\3\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\6\5\1\u0115\12\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\3\5\1\u0116\15\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\1\5\1\u0117\17\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\7\5\1\u0118"+
    "\11\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\2\5\1\u0119\16\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\14\5\1\u011a\4\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\3\5\1\u011b\15\5\7\0\2\5\1\71\3\5\3\0"+
    "\3\5\1\u011c\1\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\1\u011d\20\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\1\u011e\20\5\7\0\2\5\1\71\3\5\3\0"+
    "\1\5\1\u011f\3\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\2\5\1\u0120\16\5\7\0"+
    "\2\5\1\71\3\5\3\0\1\5\1\u0121\3\5\1\0"+
    "\4\5\24\0\15\5\2\0\21\5\7\0\2\5\1\71"+
    "\3\5\3\0\4\5\1\u0122\1\0\4\5\24\0\15\5"+
    "\2\0\1\5\1\u0123\17\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\5\5"+
    "\1\u0124\13\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\1\5\1\u0125\2\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\11\5\1\u0126\7\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\2\5\1\u0127\16\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\1\u0128\3\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\2\5\1\u0129\16\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\1\u012a\3\5"+
    "\24\0\15\5\2\0\21\5\23\0\1\u0103\43\0\1\u0103"+
    "\31\0\30\232\1\u012b\2\232\1\326\62\232\30\234\1\u012c"+
    "\2\234\1\331\62\234\4\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\1\5\1\u012d\13\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\4\5\1\u012e\10\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\3\5\1\u012f\11\5\2\0\21\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\1\u0130\14\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\1\u0131\20\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\1\u0132\20\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\4\5"+
    "\1\u0133\14\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\2\5\1\u0134\16\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\3\5\1\u0135\15\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\7\5\1\u0136\11\5\7\0\2\5\1\71\3\5"+
    "\3\0\3\5\1\u0137\1\5\1\0\4\5\24\0\15\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\1\5\1\u0138\17\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\1\5"+
    "\1\u0139\2\5\24\0\15\5\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\5\5\1\u013a\13\5\7\0\2\5\1\71\3\5"+
    "\3\0\1\5\1\u013b\3\5\1\0\4\5\24\0\15\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\1\5"+
    "\1\u013c\3\5\1\0\4\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\3\5\1\u013d\1\5"+
    "\1\0\4\5\24\0\15\5\2\0\21\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\4\5\1\u013e\14\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\17\5"+
    "\1\u013f\1\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\2\5\1\u0140\16\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\4\5\1\u0141\14\5\7\0\2\5"+
    "\1\71\3\5\3\0\3\5\1\u0142\1\5\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\4\5\24\0\15\5\2\0\1\5"+
    "\1\u0143\17\5\7\0\2\5\1\71\3\5\3\0\3\5"+
    "\1\u0144\1\5\1\0\4\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\4\5\1\u0145\14\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\1\u0146\20\5\7\0\2\5\1\71\3\5\3\0"+
    "\1\5\1\u0147\3\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\2\5\1\u0148\16\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\4\5\1\u0149\14\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\13\5\1\u014a\5\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\2\5\1\u014b\12\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\4\5\1\u014c\14\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\2\5\1\u014d\16\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\1\5\1\u014e\2\5\24\0"+
    "\15\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\6\5\1\u014f"+
    "\12\5\7\0\2\5\1\71\3\5\3\0\1\5\1\u0150"+
    "\3\5\1\0\4\5\24\0\15\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\4\5\1\u0151\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\1\5\1\u0152\3\5\1\0\4\5\24\0\15\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\1\5"+
    "\1\u0153\3\5\1\0\4\5\24\0\15\5\2\0\21\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\2\5\1\u0154\16\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\1\u0155\3\5\24\0"+
    "\15\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\6\5\1\u0156"+
    "\12\5\7\0\2\5\1\71\3\5\3\0\1\5\1\u0157"+
    "\3\5\1\0\4\5\24\0\15\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\4\5\1\u0158\14\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\5\5\1\u0159\13\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\7\5\1\u015a"+
    "\11\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\6\5\1\u015b\6\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\2\5\1\u015c\16\5\7\0\2\5\1\71"+
    "\3\5\3\0\3\5\1\u015d\1\5\1\0\4\5\24\0"+
    "\15\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\5\5\1\0\4\5\24\0\15\5\2\0\10\5\1\u015e"+
    "\10\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\5\5\1\u015f\13\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\5\5\1\u0160\13\5\7\0\2\5\1\71"+
    "\3\5\3\0\1\5\1\u0161\3\5\1\0\4\5\24\0"+
    "\15\5\2\0\21\5\7\0\2\5\1\71\3\5\3\0"+
    "\1\5\1\u0162\3\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\1\5\1\u0163"+
    "\3\5\1\0\4\5\24\0\15\5\2\0\21\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\15\5\2\0\5\5\1\u0164\13\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\6\5\1\u0165\12\5\7\0\2\5\1\71\3\5\3\0"+
    "\1\5\1\u0166\3\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\2\5\1\u0167\16\5\7\0"+
    "\2\5\1\71\3\5\3\0\5\5\1\0\4\5\24\0"+
    "\4\5\1\u0168\10\5\2\0\21\5\7\0\2\5\1\71"+
    "\3\5\3\0\5\5\1\0\4\5\24\0\15\5\2\0"+
    "\6\5\1\u0169\12\5\7\0\2\5\1\71\3\5\3\0"+
    "\3\5\1\u016a\1\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\5\5\1\0"+
    "\4\5\24\0\15\5\2\0\2\5\1\u016b\16\5\7\0"+
    "\2\5\1\71\3\5\3\0\4\5\1\u016c\1\0\4\5"+
    "\24\0\15\5\2\0\21\5\7\0\2\5\1\71\3\5"+
    "\3\0\5\5\1\0\1\5\1\u016d\2\5\24\0\15\5"+
    "\2\0\21\5\7\0\2\5\1\71\3\5\3\0\5\5"+
    "\1\0\4\5\24\0\15\5\2\0\1\5\1\u016e\17\5"+
    "\7\0\2\5\1\71\3\5\3\0\5\5\1\0\4\5"+
    "\24\0\15\5\2\0\5\5\1\u016f\13\5\7\0\2\5"+
    "\1\71\3\5\3\0\5\5\1\0\4\5\24\0\15\5"+
    "\2\0\20\5\1\u0170\7\0\2\5\1\71\3\5\3\0"+
    "\1\5\1\u0171\3\5\1\0\4\5\24\0\15\5\2\0"+
    "\21\5\7\0\2\5\1\71\3\5\3\0\4\5\1\u0172"+
    "\1\0\4\5\24\0\15\5\2\0\21\5\3\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21216];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\15\1\1\11\10\1\2\11\1\1\1\11"+
    "\4\1\1\11\1\1\1\11\6\1\2\11\12\1\1\11"+
    "\1\1\1\11\3\0\1\11\2\1\3\11\11\1\3\11"+
    "\5\1\1\0\1\1\1\0\1\11\1\1\1\11\1\0"+
    "\2\1\6\11\1\1\4\11\37\1\1\11\3\1\2\11"+
    "\1\0\20\1\1\0\4\11\43\1\2\0\1\11\1\0"+
    "\13\1\1\0\1\1\2\11\1\1\1\11\50\1\1\0"+
    "\1\11\47\1\2\11\106\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[370];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */

  public InternalXtendFlexer() {
    this((java.io.Reader)null);
  }

  public int getTokenLength() {
    return yylength();
  }
  
  public String getTokenText() {
    return yytext();
  }
  


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  InternalXtendFlexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  InternalXtendFlexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2294) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 83: 
          { return KW_False;
          }
        case 122: break;
        case 35: 
          { return KW_AsteriskAsterisk;
          }
        case 123: break;
        case 55: 
          { return KW_QuestionMarkFullStop;
          }
        case 124: break;
        case 1: 
          { return RULE_ANY_OTHER;
          }
        case 125: break;
        case 6: 
          { return KW_Asterisk;
          }
        case 126: break;
        case 8: 
          { return KW_NumberSign;
          }
        case 127: break;
        case 66: 
          { return KW_FullStopFullStopFullStop;
          }
        case 128: break;
        case 4: 
          { return RULE_INT;
          }
        case 129: break;
        case 106: 
          { return KW_Package;
          }
        case 130: break;
        case 62: 
          { return RULE_RICH_TEXT;
          }
        case 131: break;
        case 61: 
          { return KW_For;
          }
        case 132: break;
        case 104: 
          { return KW_Default;
          }
        case 133: break;
        case 5: 
          { return KW_Solidus;
          }
        case 134: break;
        case 33: 
          { return 0; /* antlr <invalid> */
          }
        case 135: break;
        case 108: 
          { return KW_Dispatch;
          }
        case 136: break;
        case 95: 
          { return KW_Static;
          }
        case 137: break;
        case 23: 
          { return KW_Semicolon;
          }
        case 138: break;
        case 84: 
          { return KW_AFTER;
          }
        case 139: break;
        case 111: 
          { return KW_Override;
          }
        case 140: break;
        case 10: 
          { return RULE_RICH_TEXT_END;
          }
        case 141: break;
        case 87: 
          { return KW_Throw;
          }
        case 142: break;
        case 74: 
          { return KW_Else;
          }
        case 143: break;
        case 69: 
          { return KW_Try;
          }
        case 144: break;
        case 45: 
          { return KW_EqualsSignEqualsSign;
          }
        case 145: break;
        case 59: 
          { return KW_VerticalLineVerticalLine;
          }
        case 146: break;
        case 20: 
          { return KW_FullStop;
          }
        case 147: break;
        case 65: 
          { return KW_EqualsSignEqualsSignEqualsSign;
          }
        case 148: break;
        case 99: 
          { return KW_Return;
          }
        case 149: break;
        case 3: 
          { return RULE_ID;
          }
        case 150: break;
        case 47: 
          { return KW_PercentSignEqualsSign;
          }
        case 151: break;
        case 76: 
          { return RULE_RICH_TEXT_START;
          }
        case 152: break;
        case 68: 
          { return KW_FOR;
          }
        case 153: break;
        case 15: 
          { return KW_LeftParenthesis;
          }
        case 154: break;
        case 80: 
          { return KW_Case;
          }
        case 155: break;
        case 60: 
          { return KW_Def;
          }
        case 156: break;
        case 28: 
          { return KW_LeftCurlyBracket;
          }
        case 157: break;
        case 121: 
          { return KW_Synchronized;
          }
        case 158: break;
        case 38: 
          { return KW_Do;
          }
        case 159: break;
        case 32: 
          { return RULE_SL_COMMENT;
          }
        case 160: break;
        case 50: 
          { return KW_PlusSignPlusSign;
          }
        case 161: break;
        case 41: 
          { return KW_HyphenMinusGreaterThanSign;
          }
        case 162: break;
        case 36: 
          { return KW_AsteriskEqualsSign;
          }
        case 163: break;
        case 27: 
          { return KW_RightSquareBracket;
          }
        case 164: break;
        case 117: 
          { return KW_Protected;
          }
        case 165: break;
        case 102: 
          { return KW_Public;
          }
        case 166: break;
        case 67: 
          { return KW_FullStopFullStopLessThanSign;
          }
        case 167: break;
        case 109: 
          { return KW_Abstract;
          }
        case 168: break;
        case 2: 
          { return RULE_WS;
          }
        case 169: break;
        case 14: 
          { return KW_Ampersand;
          }
        case 170: break;
        case 101: 
          { return KW_Native;
          }
        case 171: break;
        case 64: 
          { return KW_ExclamationMarkEqualsSignEqualsSign;
          }
        case 172: break;
        case 105: 
          { return KW_Finally;
          }
        case 173: break;
        case 26: 
          { return KW_LeftSquareBracket;
          }
        case 174: break;
        case 107: 
          { return KW_Private;
          }
        case 175: break;
        case 90: 
          { return KW_While;
          }
        case 176: break;
        case 96: 
          { return KW_Switch;
          }
        case 177: break;
        case 79: 
          { return KW_True;
          }
        case 178: break;
        case 94: 
          { return KW_BEFORE;
          }
        case 179: break;
        case 92: 
          { return KW_ELSEIF;
          }
        case 180: break;
        case 30: 
          { return KW_RightCurlyBracket;
          }
        case 181: break;
        case 118: 
          { return KW_Instanceof;
          }
        case 182: break;
        case 93: 
          { return KW_ENDFOR;
          }
        case 183: break;
        case 22: 
          { return KW_Colon;
          }
        case 184: break;
        case 17: 
          { return KW_PlusSign;
          }
        case 185: break;
        case 29: 
          { return KW_VerticalLine;
          }
        case 186: break;
        case 31: 
          { return RULE_DECIMAL;
          }
        case 187: break;
        case 21: 
          { return KW_LessThanSign;
          }
        case 188: break;
        case 12: 
          { return KW_EqualsSign;
          }
        case 189: break;
        case 113: 
          { return KW_Extension;
          }
        case 190: break;
        case 112: 
          { return KW_Volatile;
          }
        case 191: break;
        case 78: 
          { return KW_ELSE;
          }
        case 192: break;
        case 52: 
          { return KW_FullStopFullStop;
          }
        case 193: break;
        case 110: 
          { return KW_Strictfp;
          }
        case 194: break;
        case 42: 
          { return RULE_HEX;
          }
        case 195: break;
        case 37: 
          { return KW_If;
          }
        case 196: break;
        case 97: 
          { return KW_Throws;
          }
        case 197: break;
        case 119: 
          { return KW_Implements;
          }
        case 198: break;
        case 34: 
          { return KW_SolidusEqualsSign;
          }
        case 199: break;
        case 39: 
          { return KW_HyphenMinusHyphenMinus;
          }
        case 200: break;
        case 86: 
          { return KW_Super;
          }
        case 201: break;
        case 100: 
          { return KW_Create;
          }
        case 202: break;
        case 114: 
          { return KW_Interface;
          }
        case 203: break;
        case 85: 
          { return KW_ENDIF;
          }
        case 204: break;
        case 77: 
          { return RULE_COMMENT_RICH_TEXT_INBETWEEN;
          }
        case 205: break;
        case 46: 
          { return KW_EqualsSignGreaterThanSign;
          }
        case 206: break;
        case 89: 
          { return KW_Catch;
          }
        case 207: break;
        case 44: 
          { return KW_ExclamationMarkEqualsSign;
          }
        case 208: break;
        case 18: 
          { return KW_Comma;
          }
        case 209: break;
        case 11: 
          { return KW_ExclamationMark;
          }
        case 210: break;
        case 54: 
          { return KW_ColonColon;
          }
        case 211: break;
        case 51: 
          { return KW_GreaterThanSignEqualsSign;
          }
        case 212: break;
        case 58: 
          { return KW_As;
          }
        case 213: break;
        case 7: 
          { return KW_HyphenMinus;
          }
        case 214: break;
        case 115: 
          { return KW_SEPARATOR;
          }
        case 215: break;
        case 98: 
          { return KW_Typeof;
          }
        case 216: break;
        case 19: 
          { return KW_GreaterThanSign;
          }
        case 217: break;
        case 13: 
          { return KW_PercentSign;
          }
        case 218: break;
        case 91: 
          { return KW_Import;
          }
        case 219: break;
        case 70: 
          { return KW_New;
          }
        case 220: break;
        case 43: 
          { return RULE_RICH_TEXT_INBETWEEN;
          }
        case 221: break;
        case 57: 
          { return KW_IF;
          }
        case 222: break;
        case 103: 
          { return KW_Extends;
          }
        case 223: break;
        case 116: 
          { return KW_Transient;
          }
        case 224: break;
        case 25: 
          { return KW_CommercialAt;
          }
        case 225: break;
        case 81: 
          { return KW_Null;
          }
        case 226: break;
        case 53: 
          { return KW_LessThanSignGreaterThanSign;
          }
        case 227: break;
        case 56: 
          { return KW_QuestionMarkColon;
          }
        case 228: break;
        case 88: 
          { return KW_Class;
          }
        case 229: break;
        case 9: 
          { return RULE_STRING;
          }
        case 230: break;
        case 40: 
          { return KW_HyphenMinusEqualsSign;
          }
        case 231: break;
        case 63: 
          { return RULE_COMMENT_RICH_TEXT_END;
          }
        case 232: break;
        case 75: 
          { return KW_Enum;
          }
        case 233: break;
        case 24: 
          { return KW_QuestionMark;
          }
        case 234: break;
        case 71: 
          { return KW_Val;
          }
        case 235: break;
        case 49: 
          { return KW_PlusSignEqualsSign;
          }
        case 236: break;
        case 48: 
          { return KW_AmpersandAmpersand;
          }
        case 237: break;
        case 120: 
          { return KW_Annotation;
          }
        case 238: break;
        case 16: 
          { return KW_RightParenthesis;
          }
        case 239: break;
        case 82: 
          { return KW_Final;
          }
        case 240: break;
        case 73: 
          { return RULE_ML_COMMENT;
          }
        case 241: break;
        case 72: 
          { return KW_Var;
          }
        case 242: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              { return Token.EOF;
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
