/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.services.AnnotationUtil;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;

public class EndpointProxy
implements InvocationHandler {
    private final Endpoint delegate;
    private final LinkedHashMap<String, AnnotationUtil.MethodInfo> methodInfos;
    private final LinkedHashMap<String, AnnotationUtil.DelegateInfo> delegatedSegments;

    public EndpointProxy(Endpoint delegate, Class<?> interf) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        if (interf == null) {
            throw new NullPointerException("interf");
        }
        this.delegate = delegate;
        this.methodInfos = new LinkedHashMap();
        AnnotationUtil.findRpcMethods(interf, new HashSet(), methodInfo -> {
            if (this.methodInfos.put(methodInfo.method.getName(), (AnnotationUtil.MethodInfo)methodInfo) != null) {
                throw new IllegalStateException("Method overload not allowed : " + methodInfo.method);
            }
        });
        this.delegatedSegments = new LinkedHashMap();
        AnnotationUtil.findDelegateSegments(interf, new HashSet(), method -> {
            Object delegateProxy = ServiceEndpoints.toServiceObject(delegate, method.getReturnType());
            AnnotationUtil.DelegateInfo info = new AnnotationUtil.DelegateInfo();
            info.delegate = delegateProxy;
            info.method = method;
            if (this.delegatedSegments.put(method.getName(), info) != null) {
                throw new IllegalStateException("Method overload not allowed : " + method);
            }
        });
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] objectArray = args = args == null ? new Object[]{} : args;
        if (args.length <= 1) {
            AnnotationUtil.MethodInfo methodInfo = this.methodInfos.get(method.getName());
            if (methodInfo != null) {
                if (methodInfo.isNotification) {
                    this.delegate.notify(methodInfo.name, args.length == 0 ? null : args[0]);
                    return null;
                }
                return this.delegate.request(methodInfo.name, args.length == 0 ? null : args[0]);
            }
            AnnotationUtil.DelegateInfo delegateInfo = this.delegatedSegments.get(method.getName());
            if (delegateInfo != null) {
                return delegateInfo.delegate;
            }
        }
        return method.invoke((Object)this.delegate, args);
    }
}

