/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.services;

import com.google.common.base.Strings;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static void findDelegateSegments(Class<?> clazz, Set<Class<?>> visited, Consumer<Method> acceptor) {
        if (clazz == null || !visited.add(clazz)) {
            return;
        }
        AnnotationUtil.findDelegateSegments(clazz.getSuperclass(), visited, acceptor);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            AnnotationUtil.findDelegateSegments(clazz2, visited, acceptor);
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
            if (!AnnotationUtil.isDelegateMethod((Method)genericDeclaration)) continue;
            acceptor.accept((Method)genericDeclaration);
        }
    }

    public static boolean isDelegateMethod(Method method) {
        JsonDelegate jsonDelegate = method.getAnnotation(JsonDelegate.class);
        if (jsonDelegate != null) {
            if (method.getParameterCount() != 0 || !method.getReturnType().isInterface()) {
                throw new IllegalStateException("The method " + method.toString() + " is not a proper @JsonDelegate method.");
            }
            return true;
        }
        return false;
    }

    public static void findRpcMethods(Class<?> clazz, Set<Class<?>> visited, Consumer<MethodInfo> acceptor) {
        if (clazz == null || !visited.add(clazz)) {
            return;
        }
        AnnotationUtil.findRpcMethods(clazz.getSuperclass(), visited, acceptor);
        for (Class<?> interf : clazz.getInterfaces()) {
            AnnotationUtil.findRpcMethods(interf, visited, acceptor);
        }
        JsonSegment jsonSegment = clazz.getAnnotation(JsonSegment.class);
        String prefix = jsonSegment == null ? "" : jsonSegment.value() + "/";
        for (Method method : clazz.getDeclaredMethods()) {
            JsonRequest jsonRequest;
            if (method.getParameterCount() > 1) continue;
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.method = method;
            if (method.getParameterCount() > 0) {
                methodInfo.parameterType = method.getParameters()[0].getParameterizedType();
            }
            if ((jsonRequest = method.getAnnotation(JsonRequest.class)) != null) {
                String name = Strings.isNullOrEmpty((String)jsonRequest.value()) ? method.getName() : jsonRequest.value();
                methodInfo.name = jsonRequest.useSegment() ? prefix + name : name;
                methodInfo.isNotification = false;
                acceptor.accept(methodInfo);
                continue;
            }
            JsonNotification jsonNotification = method.getAnnotation(JsonNotification.class);
            if (jsonNotification == null) continue;
            String name = Strings.isNullOrEmpty((String)jsonNotification.value()) ? method.getName() : jsonNotification.value();
            methodInfo.name = jsonNotification.useSegment() ? prefix + name : name;
            methodInfo.isNotification = true;
            acceptor.accept(methodInfo);
        }
    }

    static class DelegateInfo {
        public Method method;
        public Object delegate;

        DelegateInfo() {
        }
    }

    static class MethodInfo {
        public String name;
        public Method method;
        public Type parameterType = Void.class;
        public boolean isNotification = false;

        MethodInfo() {
        }
    }
}

