/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.sync.EStructuralFeatureSyncFeature;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncItem;

public abstract class EObjectEReferenceSyncFeature<M extends EObject>
extends EStructuralFeatureSyncFeature<M, EObject> {
    public EObjectEReferenceSyncFeature(SyncBucket<M, EObject, Notification> bucket, EReference reference, EReference ... more) {
        super(bucket, (EStructuralFeature)reference, (EStructuralFeature[])more);
    }

    @Override
    protected List<? extends EObject> getContents(EObject backend) {
        return new EContentsEList(backend, this.features);
    }

    @Override
    protected EObject getNotifier(EObject backend) {
        return backend;
    }

    @Override
    protected EObject getModelOfNotifier(EObject backendNotifier) {
        return backendNotifier;
    }

    @Override
    protected Command doGetAddCommand(SyncItem<M, EObject> from, SyncItem<M, EObject> to, EObject newSource) {
        EReference reference = this.getReferencingFeature(from.getBackend(), newSource);
        final EObject copy = EcoreUtil.copy((EObject)newSource);
        return new CommandWrapper(reference.isMany() ? AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)reference, (Object)copy) : SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)reference, (Object)copy)){

            public Collection<?> getResult() {
                return Collections.singletonList(copy);
            }
        };
    }

    @Override
    protected Command doGetRemoveCommand(SyncItem<M, EObject> from, EObject oldSource, SyncItem<M, EObject> to, EObject oldTarget) {
        EReference reference = this.getReferencingFeature(to.getBackend(), oldTarget);
        return reference.isContainment() ? this.createDeleteCommand(oldTarget) : (reference.isMany() ? RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)reference, (Object)oldTarget) : SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)to.getBackend(), (Object)reference, (Object)SetCommand.UNSET_VALUE));
    }

    protected Command createDeleteCommand(EObject object) {
        return DeleteCommand.create((EditingDomain)this.getEditingDomain(), (Object)object);
    }

    protected EReference getReferencingFeature(EObject owner, EObject referenced) {
        EReference result = null;
        int i = 0;
        while (result == null && i < this.features.length) {
            if (this.contains(owner, this.features[i], referenced)) {
                result = (EReference)this.features[i];
            }
            ++i;
        }
        return result;
    }

    private boolean contains(EObject owner, EStructuralFeature feature, Object value) {
        return FeatureMapUtil.isMany((EObject)owner, (EStructuralFeature)feature) ? ((Collection)owner.eGet(feature)).contains(value) : Objects.equal((Object)owner.eGet(feature), (Object)value);
    }
}

