/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateExecutionSpecificationWithMessage;
import org.eclipse.papyrus.uml.diagram.sequence.command.DropDestructionOccurenceSpecification;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetMoveAllLineAtSamePositionCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.DisplayEvent;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.SimpleSnapHelper;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class LifeLineGraphicalNodeEditPolicy
extends DefaultGraphicalNodeEditPolicy
implements IGrillingEditpolicy {
    private GraphicalNodeEditPolicy graphicalNodeEditPolicy = null;
    private DisplayEvent displayEvent;

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        OccurrenceSpecification os;
        this.displayEvent.addFigureEvent(this.getHostFigure(), request.getLocation());
        MessageEnd end = this.getPreviousEventFromPosition(request.getLocation());
        if (end != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("previous event", end);
            request.setExtendedData(extendedData);
        }
        if ((os = this.displayEvent.getActionExecutionSpecificationEvent(this.getHostFigure(), request.getLocation())) != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("MESSAGE_SENTEVENT_REPLACE_EXECUTIONEVENT", os);
            request.setExtendedData(extendedData);
        }
        return super.getConnectionCreateCommand(request);
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        super.eraseTargetConnectionFeedback(request);
        this.displayEvent.removeFigureEvent(this.getHostFigure());
    }

    protected void eraseCreationFeedback(CreateConnectionRequest request) {
        super.eraseCreationFeedback(request);
        this.displayEvent = new DisplayEvent(this.getHost());
    }

    public void setHost(EditPart host) {
        super.setHost(host);
        this.displayEvent = new DisplayEvent(this.getHost());
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        Rectangle relativePt;
        OccurrenceSpecification os;
        this.displayEvent.addFigureEvent(this.getHostFigure(), request.getLocation());
        Command cmd = super.getConnectionAndRelationshipCompleteCommand(request);
        MessageEnd end = this.getPreviousEventFromPosition(request.getLocation());
        if (end != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("second previous event", end);
            request.setExtendedData(extendedData);
        }
        if ((os = this.displayEvent.getActionExecutionSpecificationEvent(this.getHostFigure().getParent().getParent(), request.getLocation())) != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("MESSAGE_RECEIVEEVENT_REPLACE_EXECUTIONEVENT", os);
            request.setExtendedData(extendedData);
        }
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_CREATE_EDGE.getSemanticHint())) {
            relativePt = new Rectangle(0, request.getLocation().y, 0, 0);
            this.getHostFigure().getParent().translateToRelative((Translatable)relativePt);
            NodeEditPart nodeEP = (NodeEditPart)request.getTargetEditPart();
            Bounds bounds = (Bounds)((Node)nodeEP.getModel()).getLayoutConstraint();
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "update column", (IAdaptable)new EObjectAdapter((EObject)nodeEP.getNotationView()), new Point(bounds.getX(), relativePt.y - 5));
            CompoundCommand compoundCommand = new CompoundCommand();
            DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
            GridManagementEditPolicy grid = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            SetMoveAllLineAtSamePositionCommand setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, false);
            compoundCommand.add((Command)setMoveAllLineAtSamePositionCommand);
            compoundCommand.add(cmd);
            compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)setBoundsCommand));
            setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, true);
            compoundCommand.add((Command)setMoveAllLineAtSamePositionCommand);
            return compoundCommand;
        }
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_DELETE_EDGE.getSemanticHint())) {
            relativePt = new Rectangle(request.getLocation().x, request.getLocation().y, 0, 0);
            this.getHostFigure().getParent().translateToRelative((Translatable)relativePt);
            DropDestructionOccurenceSpecification dropDestructionOccurenceSpecification = new DropDestructionOccurenceSpecification(this.getDiagramEditPart(this.getHost()).getEditingDomain(), request, (EditPart)((NodeEditPart)request.getTargetEditPart()), relativePt.getTopLeft());
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.add(cmd);
            compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)dropDestructionOccurenceSpecification));
            return compoundCommand;
        }
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_ASYNCH_EDGE.getSemanticHint()) || request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_SYNCH_EDGE.getSemanticHint())) {
            DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
            GridManagementEditPolicy grid = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            CreateExecutionSpecificationWithMessage createExecutionSpecificationwithMsg = new CreateExecutionSpecificationWithMessage(this.getDiagramEditPart(this.getHost()).getEditingDomain(), request, (EditPart)((NodeEditPart)request.getTargetEditPart()));
            CompoundCommand compoundCommand = new CompoundCommand();
            SetMoveAllLineAtSamePositionCommand setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, false);
            compoundCommand.add((Command)setMoveAllLineAtSamePositionCommand);
            compoundCommand.add(cmd);
            compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)createExecutionSpecificationwithMsg));
            setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, true);
            compoundCommand.add((Command)setMoveAllLineAtSamePositionCommand);
            return compoundCommand;
        }
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_FOUND_EDGE.getSemanticHint())) {
            return this.getBasicGraphicalNodeEditPolicy().getCommand((Request)request);
        }
        return cmd;
    }

    protected GraphicalNodeEditPolicy getBasicGraphicalNodeEditPolicy() {
        if (this.graphicalNodeEditPolicy == null) {
            this.graphicalNodeEditPolicy = new GraphicalNodeEditPolicy();
            this.graphicalNodeEditPolicy.setHost(this.getHost());
        }
        return this.graphicalNodeEditPolicy;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return this.getBasicGraphicalNodeEditPolicy().getCommand((Request)request);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return this.getBasicGraphicalNodeEditPolicy().getCommand((Request)request);
    }

    public MessageEnd getPreviousEventFromPosition(Point point) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        MessageEnd previous = null;
        LifelineEditPart lifelineEditPart = (LifelineEditPart)this.getHost();
        Lifeline lifeline = (Lifeline)lifelineEditPart.resolveSemanticElement();
        try {
            GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            if (grilling != null) {
                for (DecorationNode row : grilling.rows) {
                    Point currentPoint = GridManagementEditPolicy.getLocation(row);
                    if (currentPoint.y >= point.y || GridManagementEditPolicy.getRef(row) == null) continue;
                    for (EObject referedElement : GridManagementEditPolicy.getRef(row)) {
                        if (!(referedElement instanceof View) || !(((View)referedElement).getElement() instanceof Message)) continue;
                        Message message = (Message)((View)referedElement).getElement();
                        MessageEnd receiveEvent = message.getReceiveEvent();
                        if (lifeline.getCoveredBys().contains((Object)receiveEvent)) {
                            previous = receiveEvent;
                        }
                        MessageEnd sendEvent = message.getSendEvent();
                        if (!lifeline.getCoveredBys().contains((Object)sendEvent)) continue;
                        previous = sendEvent;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return previous;
    }

    protected void computeTargetPosition(CreateConnectionRequest request, PrecisionPoint wanted) {
        ConnectionAnchor anchor = ((NodeEditPart)request.getTargetEditPart()).getTargetConnectionAnchor((Request)request);
        if (anchor instanceof AnchorHelper.InnerPointAnchor) {
            PrecisionPoint resultedPoint = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
            while (resultedPoint.getDistance((Point)wanted) > 2.0) {
                Point original = request.getLocation().getCopy();
                PrecisionPoint diff = new PrecisionPoint(original.x - resultedPoint.x, original.y - resultedPoint.y);
                PrecisionRectangle ptOnScreen = new PrecisionRectangle((double)resultedPoint.x, (double)resultedPoint.y, 0.0, 0.0);
                SimpleSnapHelper.snapAPoint(ptOnScreen, this.getHost().getRoot());
                PrecisionPoint Result = new PrecisionPoint(ptOnScreen.x + diff.x, ptOnScreen.y + diff.y);
                request.setLocation((Point)Result);
                anchor = ((NodeEditPart)request.getTargetEditPart()).getTargetConnectionAnchor((Request)request);
                resultedPoint = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
            }
        }
    }

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        if (request.getTargetEditPart() instanceof NodeEditPart) {
            ConnectionAnchor targetAnchor = ((NodeEditPart)request.getTargetEditPart()).getTargetConnectionAnchor((Request)request);
            if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost()) && targetAnchor instanceof AnchorHelper.InnerPointAnchor) {
                PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)targetAnchor).getTerminal());
                PrecisionRectangle ptOnScreen = new PrecisionRectangle((double)pt.x, (double)pt.y, 0.0, 0.0);
                SimpleSnapHelper.snapAPoint(ptOnScreen, this.getHost().getRoot());
                this.computeTargetPosition(request, new PrecisionPoint(ptOnScreen.x, ptOnScreen.y));
            }
        }
        return super.getFeedbackHelper(request);
    }
}

