/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;

public class DurationConstraintLocator
extends AdvancedBorderItemLocator {
    public DurationConstraintLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public DurationConstraintLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public DurationConstraintLocator(IFigure parentFigure, int position) {
        super(parentFigure, position);
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint();
        rectSuggested.setSize(size);
        Rectangle suggestedRectIndiagram = rectSuggested.getCopy();
        suggestedRectIndiagram.x += this.getParentFigure().getBounds().x;
        suggestedRectIndiagram.y += this.getParentFigure().getBounds().y;
        suggestedRectIndiagram = this.getValidLocation(suggestedRectIndiagram, borderItem);
        borderItem.setBounds(suggestedRectIndiagram.getCopy());
        suggestedRectIndiagram.x -= this.getParentFigure().getBounds().x;
        suggestedRectIndiagram.y -= this.getParentFigure().getBounds().y;
        this.setConstraint(suggestedRectIndiagram);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        int headerYOffset = 20;
        int parentMiddleX = this.getParentFigure().getBounds().x + this.getParentFigure().getBounds().width / 2;
        if (proposedLocation.x < parentMiddleX) {
            proposedLocation.setX(parentMiddleX - proposedLocation.width());
        } else {
            proposedLocation.setX(parentMiddleX);
        }
        if (proposedLocation.y < this.getParentFigure().getBounds().y + headerYOffset) {
            proposedLocation.setY(this.getParentFigure().getBounds().y + headerYOffset);
        }
        if (proposedLocation.y + proposedLocation.height > this.getParentFigure().getBounds().bottom()) {
            proposedLocation.setY(this.getParentFigure().getBounds().bottom() - proposedLocation.height);
        }
        return super.getValidLocation(proposedLocation, borderItem);
    }
}

