/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ZOrderRequest;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;

public class ZOrderAction
extends AbstractGraphicalParametricAction {
    public static final String BRING_TO_FRONT = "bringToFront";
    public static final String SEND_TO_BACK = "sendToBack";
    public static final String BRING_FORWARD = "bringForward";
    public static final String SEND_BACKWARD = "sendBackward";

    public ZOrderAction(String parameter, List<IGraphicalEditPart> selectedElements) {
        super(parameter, selectedElements);
    }

    @Override
    public boolean isEnabled() {
        if (this.getSelection().isEmpty()) {
            return false;
        }
        EditPart editPart = (EditPart)this.getSelection().get(0);
        GraphicalEditPart parentEditPart = (GraphicalEditPart)editPart.getParent();
        if (parentEditPart == null) {
            return false;
        }
        if (parentEditPart instanceof IEditableEditPart && !((IEditableEditPart)parentEditPart).isEditModeEnabled()) {
            return false;
        }
        if (!(parentEditPart.getContentPane().getLayoutManager() instanceof XYLayout)) {
            return false;
        }
        for (EditPart editPart2 : this.getSelection()) {
            if (parentEditPart != editPart2.getParent()) {
                return false;
            }
            if (!(editPart2 instanceof IEditableEditPart) || ((IEditableEditPart)editPart2).isEditModeEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Command getBuildedCommand() {
        Command cmd = null;
        ZOrderRequest request = null;
        if (BRING_FORWARD.equals(this.getParameter())) {
            request = new ZOrderRequest("bringForwardAction");
        } else if (BRING_TO_FRONT.equals(this.getParameter())) {
            request = new ZOrderRequest("bringToFrontAction");
        } else if (SEND_BACKWARD.equals(this.getParameter())) {
            request = new ZOrderRequest("sendBackwardAction");
        } else if (SEND_TO_BACK.equals(this.getParameter())) {
            request = new ZOrderRequest("sendToBackAction");
        }
        request.setPartsToOrder(this.getSelection());
        cmd = this.getSelection().get(0).getParent().getCommand((Request)request);
        return cmd == null ? UnexecutableCommand.INSTANCE : cmd;
    }
}

