/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.advices;

import java.util.List;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.activity.edit.commands.util.PinUpdateCommand;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.IPinUpdater;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.PinUpdaterFactory;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.preferences.AutomatedModelCompletionPreferencesInitializer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;

public class CallEventEditHelperAdvice
extends AbstractEditHelperAdvice {
    public ICommand getAfterSetCommand(SetRequest request) {
        if (request.getFeature().equals(UMLPackage.eINSTANCE.getCallEvent_Operation())) {
            IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
            boolean synchronizePinPreference = false;
            CompositeCommand command = new CompositeCommand("Update callEvent");
            CallEvent callEvent = (CallEvent)request.getElementToEdit();
            Package root = PackageUtil.getRootPackage((Element)callEvent);
            if (root != null) {
                synchronizePinPreference = prefStore.getString("org.eclipse.papyrus.uml.diagram.activity.preferences.acceptCallAction").equals(AutomatedModelCompletionPreferencesInitializer.PIN_SYNCHRONIZATION);
                if (synchronizePinPreference) {
                    List allAcceptCallAction = ElementUtil.getInstancesFilteredByType((Package)root, AcceptCallAction.class, null);
                    for (AcceptCallAction acceptCallAction : allAcceptCallAction) {
                        if (!(acceptCallAction instanceof AcceptCallAction)) continue;
                        for (Trigger t : acceptCallAction.getTriggers()) {
                            if (!(t.getEvent() instanceof CallEvent) || t.getEvent() != callEvent) continue;
                            IPinUpdater updater = PinUpdaterFactory.getInstance().instantiate((ActivityNode)acceptCallAction);
                            command.add(new PinUpdateCommand<AcceptCallAction>("Update accept event action pins", updater, acceptCallAction));
                        }
                    }
                }
                if (!command.isEmpty()) {
                    return command;
                }
            }
        }
        return super.getAfterSetCommand(request);
    }
}

