/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.toolsmiths.Activator;
import org.eclipse.papyrus.toolsmiths.factory.FileBasedExtensionFactory;
import org.eclipse.papyrus.toolsmiths.messages.Messages;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizationPluginPackage;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.FileBasedCustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.Profile;
import org.w3c.dom.Element;

public class ProfileExtensionFactory
extends FileBasedExtensionFactory {
    public ProfileExtensionFactory() {
        super(Messages.ProfileExtensionFactory_Profile, "org.eclipse.papyrus.uml.extensionpoints.UMLProfile", "path", "profile", true);
    }

    public void addElement(CustomizableElement element, IPluginEditor editor) {
        super.addElement(element, editor);
        editor.addDependency("org.eclipse.papyrus.uml.extensionpoints");
    }

    protected Element createExtension(FileBasedCustomizableElement element, IPluginEditor editor) {
        Element extension = super.createExtension(element, editor);
        Profile profile = (Profile)element;
        extension.setAttribute("name", profile.getName());
        if (profile.getDescription() != null) {
            extension.setAttribute("description", profile.getDescription());
        }
        if (profile.getIconpath() != null && !profile.getIconpath().trim().equals("")) {
            this.copyIcon(profile.getIconpath(), editor);
            extension.setAttribute("iconpath", this.getIconPath(profile.getIconpath()));
        }
        if (profile.getProvider() != null) {
            extension.setAttribute("provider", profile.getProvider());
        }
        return extension;
    }

    protected void copyIcon(String path, IPluginEditor editor) {
        File sourceFile = FileUtil.getFile((String)path);
        File targetFile = FileUtil.getWorkspaceFile((String)("/" + editor.getProject().getName() + "/" + this.getIconPath(path)));
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            this.copy(new FileInputStream(sourceFile), targetFile);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
        editor.addToBuild("icons/");
    }

    protected String getIconPath(String path) {
        return "icons/" + this.getFileName(path);
    }

    protected String getFileName(String path) {
        String fileName = (path = path.replace("\\", "/")).indexOf("/") < 0 ? path : path.substring(path.lastIndexOf("/") + 1, path.length());
        return fileName;
    }

    protected String getTargetPath(FileBasedCustomizableElement element) {
        return "/umlProfile/" + this.getFileName(element);
    }

    public EClass getCustomizableElementClass() {
        return CustomizationPluginPackage.eINSTANCE.getProfile();
    }
}

