/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class NewFilterDialog
extends SelectionDialog {
    private List<CommandParameter> newChildDescriptors;
    private CommandParameter result;

    public NewFilterDialog(Shell parentShell, List<CommandParameter> newChildDescriptors) {
        super(parentShell);
        this.newChildDescriptors = newChildDescriptors;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Create a new filter");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText("Create");
    }

    protected Control createDialogArea(Composite parent) {
        Composite self = (Composite)super.createDialogArea(parent);
        Label description = new Label(self, 64);
        description.setText("Select the kind of Filter to create");
        ListViewer viewer = new ListViewer(self, 2820);
        viewer.setContentProvider((IContentProvider)new NewFilterContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                CommandParameter cp = (CommandParameter)element;
                EObject value = cp.getEValue();
                return value.eClass().getName();
            }
        });
        viewer.addSelectionChangedListener(event -> {
            this.result = (CommandParameter)event.getStructuredSelection().getFirstElement();
            this.updateButtons();
        });
        viewer.setInput(new Object());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)description);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewer.getList());
        return self;
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(this.result != null);
    }

    public CommandParameter getNewChild() {
        return this.result;
    }

    private class NewFilterContentProvider
    implements IStructuredContentProvider {
        private NewFilterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return NewFilterDialog.this.newChildDescriptors.stream().filter(cp -> cp.getEStructuralFeature() instanceof EReference).filter(cp -> EMFHelper.isSuperType((EClassifier)FiltersPackage.Literals.FILTER, (EClassifier)cp.getEReference().getEType())).collect(Collectors.toList()).toArray();
        }
    }
}

