/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.StereotypeNameContentProposal;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.StereotypeQualifiedNameContentProposal;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class PossibleStereotypeContentProposalProvider
implements IContentProposalProvider {
    private Element umlElement;

    public PossibleStereotypeContentProposalProvider(Element umlElement) {
        this.umlElement = umlElement;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<StereotypeNameContentProposal> shortProposals = new ArrayList<StereotypeNameContentProposal>();
        ArrayList<StereotypeQualifiedNameContentProposal> longProposals = new ArrayList<StereotypeQualifiedNameContentProposal>();
        EList appliedStereotypes = this.umlElement.getAppliedStereotypes();
        for (Stereotype st : appliedStereotypes) {
            String simpleName = st.getName();
            String qualifiedName = st.getQualifiedName();
            if (this.match(simpleName, contents, position)) {
                shortProposals.add(new StereotypeNameContentProposal(st));
            }
            if (!this.match(qualifiedName, contents, position)) continue;
            longProposals.add(new StereotypeQualifiedNameContentProposal(st));
        }
        EList applicableStereotypes = this.umlElement.getApplicableStereotypes();
        for (Stereotype st : applicableStereotypes) {
            if (appliedStereotypes.contains(st)) continue;
            String simpleName = st.getName();
            String qualifiedName = st.getQualifiedName();
            if (this.match(simpleName, contents, position)) {
                shortProposals.add(new StereotypeNameContentProposal(st));
            }
            if (!this.match(qualifiedName, contents, position)) continue;
            longProposals.add(new StereotypeQualifiedNameContentProposal(st));
        }
        Collections.sort(shortProposals);
        Collections.sort(longProposals);
        shortProposals.addAll(longProposals);
        return shortProposals.toArray(new IContentProposal[shortProposals.size()]);
    }

    private boolean match(String name, String proposal, int position) {
        return position < name.length() && proposal.substring(0, position).equalsIgnoreCase(name.substring(0, position));
    }
}

