/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateLinkEndDateDialog
extends FormDialog {
    private Association association;
    private List<Button> associationEnds = new ArrayList<Button>();
    private List<Property> selectedProperties = new ArrayList<Property>();

    public CreateLinkEndDateDialog(Shell shell, Association association) {
        super(shell);
        this.association = association;
    }

    protected void createFormContent(IManagedForm mForm) {
        mForm.getForm().setText("Select association End");
        ScrolledForm scrolledForm = mForm.getForm();
        FormToolkit toolkit = mForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createAssociationSection(parent, toolkit);
        scrolledForm.reflow(true);
    }

    private void createAssociationSection(Composite parent, FormToolkit toolkit) {
        String lSectionTitle = "Association End";
        Section lSection = toolkit.createSection(parent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = toolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 1;
        lBody.setLayout((Layout)lLayout);
        this.associationEnds.clear();
        Iterator memberEndsIterator = this.association.getMemberEnds().iterator();
        Image image = this.getTypeImage();
        while (memberEndsIterator.hasNext()) {
            Property memberEnd = (Property)memberEndsIterator.next();
            Button associationEndButton = toolkit.createButton(lBody, memberEnd.getQualifiedName() != null ? memberEnd.getQualifiedName() : memberEnd.getName(), 32);
            associationEndButton.setImage(image);
            this.associationEnds.add(associationEndButton);
        }
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        this.selectedProperties.clear();
        int i = 0;
        while (i < this.associationEnds.size()) {
            Button memberEndbutton = this.associationEnds.get(i);
            if (memberEndbutton.getSelection()) {
                this.selectedProperties.add((Property)this.association.getMemberEnds().get(i));
            }
            ++i;
        }
        super.okPressed();
    }

    private Image getTypeImage() {
        return UMLElementTypes.getImage((ENamedElement)UMLPackage.eINSTANCE.getAssociation_MemberEnd());
    }

    public List<Property> getSelectedProperties() {
        return this.selectedProperties;
    }
}

