/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IFeatureProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FeatureProjectEditor
extends ProjectEditor
implements IFeatureProjectEditor {
    public static final String FEATURE_XML_FILE = "feature.xml";
    private static final String FEATURE_NATURE = "org.eclipse.pde.FeatureNature";
    private static final String FEATURE_BUILDER = "org.eclipse.pde.FeatureBuilder";
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String VERSION = "version";
    private static final String PROVIDER = "provider-name";
    private static final String URL = "url";
    private static final String COPYRIGHT = "copyright";
    private static final String LICENSE = "license";
    private static final String DESCRIPTION = "description";
    private static final String OS = "os";
    private static final String WS = "ws";
    private static final String NL = "nl";
    private static final String ARCH = "arch";
    private static final String UPDATE = "update";
    private static final String PLUGIN = "plugin";
    private static final String IMPORT = "import";
    private static final String INCLUDES = "includes";
    private static final String REQUIRES = "requires";
    private static final String FEATURE = "feature";
    private Document featureXML;
    private IFile featureFile;
    private Element featureRoot;

    public FeatureProjectEditor(IProject project) throws ParserConfigurationException, SAXException, IOException, CoreException {
        super(project);
    }

    @Override
    public void init() {
        this.featureFile = this.getFeature();
        if (this.featureFile != null && this.featureFile.exists()) {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                this.featureXML = documentBuilder.parse(this.featureFile.getLocation().toOSString());
                this.featureRoot = this.featureXML.getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SAXException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public void createFiles(Set<String> files) {
        if (files.contains(FEATURE_XML_FILE)) {
            this.featureFile = this.getProject().getFile(FEATURE_XML_FILE);
            if (!this.featureFile.exists()) {
                InputStream content = this.getInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<feature>\n</feature>\n\n");
                try {
                    this.featureFile.create(content, true, null);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean exists() {
        return this.getFeature().exists() && super.exists();
    }

    private void setAttribute(String attributeName, String attributeValue) {
        this.setAttribute(this.featureRoot, attributeName, attributeValue);
    }

    private void setAttribute(Element element, String attributeName, String attributeValue) {
        if (!Objects.equals(element.getAttribute(attributeName), attributeValue)) {
            this.touch();
            element.setAttribute(attributeName, attributeValue);
        }
    }

    private void setTextContent(Element element, String text) {
        if (!Objects.equals(element.getTextContent(), text)) {
            this.touch();
            element.setTextContent(text);
        }
    }

    private IFile getFeature() {
        IFile result = this.getProject().getFile(FEATURE_XML_FILE);
        if (result.exists()) {
            return result;
        }
        return null;
    }

    @Override
    protected void doSave() {
        if (this.featureFile != null && this.featureFile.exists()) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(this.featureXML);
                transformer.transform(source, result);
                InputStream inputStream = this.getInputStream(result.getWriter().toString());
                this.featureFile.setContents(inputStream, true, true, null);
            }
            catch (TransformerException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        super.doSave();
    }

    @Override
    public Set<String> getMissingNature() {
        Set<String> result = super.getMissingNature();
        if (!this.hasNature(FEATURE_NATURE)) {
            result.add(FEATURE_NATURE);
        }
        return result;
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> result = super.getMissingFiles();
        IFile feature = this.getProject().getFile(FEATURE_XML_FILE);
        if (!feature.exists()) {
            result.add(FEATURE_XML_FILE);
        }
        return result;
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        Set<String> result = super.getMissingBuildCommand();
        if (!this.hasBuildCommand(FEATURE_BUILDER)) {
            result.add(FEATURE_BUILDER);
        }
        return result;
    }

    @Override
    public Document getDocument() {
        return this.featureXML;
    }

    private String getAttribute(String name) {
        return this.getAttribute(this.featureRoot, name);
    }

    private String getAttribute(Element element, String name) {
        return element.getAttribute(name);
    }

    @Override
    public String getId() {
        return this.getAttribute(ID);
    }

    @Override
    public String getLabel() {
        return this.getAttribute(LABEL);
    }

    @Override
    public String getVersion() {
        return this.getAttribute(VERSION);
    }

    @Override
    public String getProviderName() {
        return this.getAttribute(PROVIDER);
    }

    @Override
    public String getDescriptionText() {
        Element description = this.getNodeChild(DESCRIPTION, this.featureRoot);
        return description == null ? null : description.getTextContent().trim();
    }

    @Override
    public String getDescriptionURL() {
        Element description = this.getNodeChild(DESCRIPTION, this.featureRoot);
        return description == null || !description.hasAttribute(URL) ? null : description.getAttribute(URL);
    }

    @Override
    public String getCopyrightURL() {
        Element copyrightNode = this.getNode(COPYRIGHT);
        if (copyrightNode != null) {
            String value = copyrightNode.getAttribute(URL);
            if (value != null && value.startsWith("%")) {
                IFile file = this.getProject().getFile("feature.properties");
                Properties prop = new Properties();
                try {
                    prop.load(file.getContents());
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
                Object val = prop.get(URL);
                if (val != null) {
                    return (String)val;
                }
            }
            return copyrightNode.getAttribute(URL);
        }
        return null;
    }

    @Override
    public String getCopyrightText() {
        Element copyrightNode = this.getNode(COPYRIGHT);
        return copyrightNode != null ? copyrightNode.getTextContent() : null;
    }

    @Override
    public String getLicenseText() {
        Element license = this.getNodeChild(LICENSE, this.featureRoot);
        return license == null ? null : license.getTextContent().trim();
    }

    @Override
    public String getLicenseURL() {
        Element license = this.getNodeChild(LICENSE, this.featureRoot);
        return license == null || !license.hasAttribute(URL) ? null : license.getAttribute(URL);
    }

    @Override
    public String getOS() {
        return this.getAttribute(OS);
    }

    @Override
    public String getWS() {
        return this.getAttribute(WS);
    }

    @Override
    public String getNL() {
        return this.getAttribute(NL);
    }

    @Override
    public String getArch() {
        return this.getAttribute(ARCH);
    }

    @Override
    public void setId(String id) {
        this.setAttribute(ID, id);
    }

    @Override
    public void setLabel(String label) {
        this.setAttribute(LABEL, label);
    }

    @Override
    public void setVersion(String version) {
        this.setAttribute(VERSION, version);
    }

    @Override
    public void setProviderName(String providerName) {
        this.setAttribute(PROVIDER, providerName);
    }

    private Element forceElement(String name) {
        return this.forceElement(this.featureRoot, name);
    }

    private Element forceElement(Element parent, String name) {
        Element result = this.getNodeChild(name, parent);
        if (result == null) {
            this.touch();
            result = this.createElement(name);
            parent.appendChild(result);
        }
        return result;
    }

    @Override
    public void setDescription(String descriptionURL, String description) {
        if (this.featureRoot != null) {
            Element extension = this.forceElement(DESCRIPTION);
            this.setAttribute(extension, URL, descriptionURL);
            this.setTextContent(extension, description);
        }
    }

    @Override
    public void setCopyright(String copyrightURL, String copyrightDesc) {
        this.setURLNode(COPYRIGHT, copyrightURL, copyrightDesc);
    }

    @Override
    public void setLicense(String licenseURL, String licenseDesc) {
        this.setURLNode(LICENSE, licenseURL, licenseDesc);
    }

    @Override
    public void setOS(String os) {
        this.setAttribute(OS, os);
    }

    @Override
    public void setWS(String ws) {
        this.setAttribute(WS, ws);
    }

    @Override
    public void setNL(String nl) {
        this.setAttribute(NL, nl);
    }

    @Override
    public void setArch(String architecture) {
        this.setAttribute(ARCH, architecture);
    }

    @Override
    public void setUpdateURL(String urlLabel, String url) {
        Element urlNode = this.forceElement(URL);
        Element updateNode = this.forceElement(urlNode, UPDATE);
        this.setAttribute(updateNode, LABEL, urlLabel);
        this.setAttribute(updateNode, URL, url);
    }

    @Override
    public void addPlugin(String pluginName) {
        Element plugin = this.forcePlugin(pluginName);
        if (!plugin.hasAttribute(VERSION)) {
            plugin.setAttribute(VERSION, "0.0.0");
        }
        if (!plugin.hasAttribute("download-size")) {
            plugin.setAttribute("download-size", "0");
        }
        if (!plugin.hasAttribute("install-size")) {
            plugin.setAttribute("install-size", "0");
        }
        if (!plugin.hasAttribute("unpack")) {
            plugin.setAttribute("unpack", "false");
        }
    }

    @Override
    public void addRequiredFeature(String featureName, String version) {
        Element feature = this.forceRequiredFeature(featureName);
        feature.setAttribute(VERSION, version);
    }

    @Override
    public void addRequiredPlugin(String pluginName) {
        this.forceRequiredPlugin(pluginName);
    }

    @Override
    public void addInclude(String featureName, String version) {
        Element includeNode = this.forceInclude(featureName);
        this.setAttribute(includeNode, VERSION, version == null ? "0.0.0" : version);
    }

    private Element createElement(String elementName) {
        return this.featureXML.createElement(elementName);
    }

    protected void setURLNode(String nodeName, String url, String description) {
        if (this.featureRoot != null) {
            Element urlNode = this.forceElement(nodeName);
            if (url != null) {
                this.setAttribute(urlNode, URL, url);
            }
            this.setTextContent(urlNode, description);
        }
    }

    private Element getElement(Element parentElement, String nodeName, String attributeName, String attributeValue) {
        NodeList childNodes = parentElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (nodeName.equals(item.getNodeName()) && attributeValue.equals(this.getNodeAttribute(item, attributeName)) && item instanceof Element) {
                return (Element)item;
            }
            ++i;
        }
        return null;
    }

    private Element getNodeChild(String childName, Element node) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes == null) {
            return null;
        }
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (item.getNodeName().equals(childName) && item instanceof Element) {
                return (Element)item;
            }
            ++i;
        }
        return null;
    }

    private Element getNode(String nodeName) {
        if (this.featureRoot != null) {
            NodeList nodes = this.featureRoot.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                String name;
                Node item = nodes.item(i);
                if (item instanceof NodeList && (name = item.getNodeName()).equals(nodeName) && item instanceof Element) {
                    return (Element)item;
                }
                ++i;
            }
        }
        return null;
    }

    private Element getPlugin(String pluginName) {
        return this.getElement(this.featureRoot, PLUGIN, ID, pluginName);
    }

    private Element forcePlugin(String pluginName) {
        Element result = this.getPlugin(pluginName);
        if (result == null) {
            result = this.createElement(PLUGIN);
            this.featureRoot.appendChild(result);
            this.setAttribute(result, ID, pluginName);
        }
        return result;
    }

    private Element getInclude(String featureName) {
        return this.getElement(this.featureRoot, INCLUDES, ID, featureName);
    }

    private Element forceInclude(String featureName) {
        Element result = this.getInclude(featureName);
        if (result == null) {
            result = this.createElement(INCLUDES);
            this.featureRoot.appendChild(result);
            this.setAttribute(result, ID, featureName);
        }
        return result;
    }

    private Element getRequiredPlugin(String pluginName) {
        Element requires = this.getNode(REQUIRES);
        if (requires != null) {
            return this.getElement(requires, IMPORT, PLUGIN, pluginName);
        }
        return null;
    }

    private Element forceRequiredPlugin(String pluginName) {
        Element result = this.getRequiredPlugin(pluginName);
        if (result == null) {
            result = this.createElement(IMPORT);
            this.forceElement(REQUIRES).appendChild(result);
            this.setAttribute(result, PLUGIN, pluginName);
        }
        return result;
    }

    private String getNodeAttribute(Node node, String name) {
        Node attribute = node.getAttributes().getNamedItem(name);
        return attribute != null ? attribute.getNodeValue() : null;
    }

    private Element getRequiredFeature(String featureName) {
        Element requires = this.getNode(REQUIRES);
        if (requires != null) {
            return this.getElement(requires, IMPORT, FEATURE, featureName);
        }
        return null;
    }

    private Element forceRequiredFeature(String featureName) {
        Element result = this.getRequiredFeature(featureName);
        if (result == null) {
            result = this.createElement(IMPORT);
            this.forceElement(REQUIRES).appendChild(result);
            this.setAttribute(result, FEATURE, featureName);
        }
        return result;
    }
}

