/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.ModelElementMatch;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class PapyrusOCLQuery
extends AbstractPapyrusQuery {
    private EObject contextObject;
    private PapyrusSearchResult results;
    private ScopeEntry scopeEntry;
    private BaseDocument queryEditorDocument;
    private ParserContext parserContext;
    private EnvironmentFactory environmentFactory;
    private ModelManager modelManager;
    protected Set<AbstractResultEntry> fResults = null;

    public PapyrusOCLQuery(BaseDocument queryEditorDocument, ParserContext parserContext, EnvironmentFactory environmentFactory, ModelManager modelManager, EObject contextObject, ScopeEntry scopeEntry) {
        this.queryEditorDocument = queryEditorDocument;
        this.contextObject = contextObject;
        this.scopeEntry = scopeEntry;
        this.parserContext = parserContext;
        this.environmentFactory = environmentFactory;
        this.modelManager = modelManager;
        ArrayList<ScopeEntry> scopeEntries = new ArrayList<ScopeEntry>();
        scopeEntries.add(scopeEntry);
        this.results = new PapyrusSearchResult(this);
        this.fResults = new HashSet<AbstractResultEntry>();
    }

    protected boolean evaluate(final String expression) {
        if (expression == null || expression.trim().length() <= 0) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusOCLQuery_0, (String)Messages.PapyrusOCLQuery_1);
            return false;
        }
        boolean result = true;
        try {
            BaseDocument doc = this.queryEditorDocument;
            BaseDocument editorDocument = this.queryEditorDocument;
            Object value = null;
            try {
                value = editorDocument.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                    public Object exec(XtextResource state) throws Exception {
                        if (!$assertionsDisabled && state == null) {
                            throw new AssertionError();
                        }
                        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                        EvaluationRunnable runnable = new EvaluationRunnable((CSResource)state, expression);
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                        return runnable.getValue();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value instanceof InvalidValueException) {
                InvalidValueException exception = (InvalidValueException)((Object)value);
                Throwable cause = exception.getCause();
                if (cause != null) {
                    // empty if block
                }
            } else if (value != null) {
                CollectionValue collectionValue = ValueUtil.isCollectionValue((Object)value);
                if (collectionValue != null) {
                    for (Object elementValue : collectionValue.iterable()) {
                        if (!(elementValue instanceof EObject)) continue;
                        ModelElementMatch match = new ModelElementMatch(elementValue, this.scopeEntry);
                        this.fResults.add((AbstractResultEntry)match);
                    }
                } else if (value instanceof EObject) {
                    ModelElementMatch match = new ModelElementMatch(value, this.scopeEntry);
                    this.fResults.add((AbstractResultEntry)match);
                }
            }
        }
        catch (Exception e) {
            result = false;
            e.getLocalizedMessage();
        }
        return result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.results.removeAll();
        this.fResults.clear();
        this.evaluate(this.queryEditorDocument.get().trim());
        monitor.done();
        return Status.OK_STATUS;
    }

    protected void evaluateAndAddToResult(String value, Object attribute, Pattern pattern, Object participant, ScopeEntry scopeEntry) {
        value = value != null ? value : "";
        Matcher m = pattern.matcher(value);
    }

    protected void evaluate(Collection<EObject> participants, ScopeEntry scopeEntry) {
    }

    public String getLabel() {
        return Messages.PapyrusQuery_6;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        for (AbstractResultEntry match : this.fResults) {
            this.results.addMatch((Match)match);
        }
        return this.results;
    }

    @Override
    public String getSearchQueryText() {
        if (this.queryEditorDocument.get().length() > 25) {
            return this.queryEditorDocument.get().subSequence(0, 25) + "...";
        }
        return this.queryEditorDocument.get();
    }

    private class EvaluationRunnable
    implements IRunnableWithProgress {
        private final CSResource resource;
        private final String expression;
        private Object value = null;

        public EvaluationRunnable(CSResource resource, String expression) {
            this.resource = resource;
            this.expression = expression;
        }

        public Object getValue() {
            return this.value;
        }

        public void run(IProgressMonitor monitor) {
            ExpressionInOCL expressionInOCL;
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Progress_Title, (Object)this.expression), 10);
            monitor.subTask(ConsoleMessages.Progress_Synchronising);
            monitor.worked(1);
            try {
                PivotUtil.checkResourceErrors((String)"", (Resource)this.resource);
                expressionInOCL = PapyrusOCLQuery.this.parserContext.getExpression(this.resource);
            }
            catch (ParserException e) {
                this.value = new InvalidValueException((Exception)((Object)e), ConsoleMessages.Result_ParsingFailure);
                return;
            }
            if (expressionInOCL != null) {
                monitor.subTask(ConsoleMessages.Progress_Extent);
                ModelManager modelManager2 = PapyrusOCLQuery.this.modelManager;
                if (modelManager2 == null) {
                    modelManager2 = PapyrusOCLQuery.this.modelManager = PapyrusOCLQuery.this.environmentFactory.createModelManager((Object)PapyrusOCLQuery.this.contextObject);
                }
                EvaluationEnvironment evaluationEnvironment = PapyrusOCLQuery.this.environmentFactory.createEvaluationEnvironment((NamedElement)expressionInOCL, modelManager2);
                Object contextValue = PapyrusOCLQuery.this.environmentFactory.getIdResolver().boxedValueOf((Object)PapyrusOCLQuery.this.contextObject);
                evaluationEnvironment.add((TypedElement)ClassUtil.nonNullModel((Object)expressionInOCL.getOwnedContext()), contextValue);
                monitor.worked(2);
                monitor.subTask(ConsoleMessages.Progress_Evaluating);
                try {
                    EvaluationVisitor evaluationVisitor = PapyrusOCLQuery.this.environmentFactory.createEvaluationVisitor(evaluationEnvironment);
                    evaluationVisitor.setMonitor(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                    this.value = evaluationVisitor.visitExpressionInOCL(expressionInOCL);
                }
                catch (InvalidValueException e) {
                    this.value = e;
                }
                catch (Exception e) {
                    this.value = new InvalidValueException(e, ConsoleMessages.Result_EvaluationFailure);
                }
            }
            monitor.worked(4);
        }
    }
}

