/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.releng.tools.internal.popup.actions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.transformer.TransformationManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.releng.tools.internal.Activator;
import org.eclipse.papyrus.releng.tools.internal.Messages;
import org.eclipse.papyrus.releng.tools.internal.popup.actions.DependencyUpdater;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.osgi.framework.Bundle;

public class UpdateDependencies {
    public void updateDependencies(List<IFile> filesToUpdate, Shell activeShell) {
        IFile aggregationBuildFile = null;
        boolean cancelled = false;
        ArrayList updated = Lists.newArrayListWithExpectedSize((int)4);
        try {
            if (!filesToUpdate.isEmpty()) {
                List<IFile> aggregationBuildFiles = UpdateDependencies.findAggregationBuildFiles();
                aggregationBuildFile = UpdateDependencies.chooseAggregationBuildFile(aggregationBuildFiles, activeShell);
                if (aggregationBuildFile == null) {
                    cancelled = true;
                } else {
                    Aggregation aggregation = UpdateDependencies.loadAggregationModel(aggregationBuildFile);
                    if (aggregation != null) {
                        HashMap context = Maps.newHashMap();
                        for (IFile file : filesToUpdate) {
                            if (!this.updateFile(file, aggregation, activeShell, context)) continue;
                            updated.add(file);
                        }
                    }
                }
            }
        }
        catch (OperationCanceledException e) {
            cancelled = true;
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "Error", (Throwable)e));
            MessageDialog.openError((Shell)activeShell, (String)Messages.UpdateRMapAction_error, (String)e.getLocalizedMessage());
        }
        if (updated.isEmpty()) {
            if (!cancelled) {
                MessageDialog.openInformation((Shell)activeShell, (String)"No Files Updated", (String)"No files were updated for new dependencies.");
            }
        } else {
            String fileList = Joiner.on((String)", ").join(Iterables.transform((Iterable)updated, (Function)new Function<IFile, IPath>(){

                public IPath apply(IFile input) {
                    return input.getFullPath();
                }
            }));
            MessageDialog.openInformation((Shell)activeShell, (String)Messages.UpdateRMapAction_mapWasUpdatedTitle, (String)NLS.bind((String)Messages.UpdateRMapAction_mapWasUpdated, (Object)fileList, (Object)aggregationBuildFile.getFullPath().toString()));
        }
    }

    public static List<IFile> findAggregationBuildFiles() throws CoreException {
        IProject[] projects;
        ArrayList<IFile> aggregationBuildFiles = new ArrayList<IFile>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                IResource[] members;
                IResource[] iResourceArray = members = project.members();
                int n3 = members.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource resource = iResourceArray[n4];
                    if (resource.getType() == 1 && resource.getName().endsWith(".aggr")) {
                        aggregationBuildFiles.add((IFile)resource);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return aggregationBuildFiles;
    }

    public static IFile chooseAggregationBuildFile(List<IFile> aggregationBuildFiles, Shell activeShell) {
        if (aggregationBuildFiles.size() == 0) {
            MessageDialog.openWarning((Shell)activeShell, (String)Messages.UpdateRMapAction_noBuildModelFound, (String)Messages.UpdateRMapAction_noBuildModelFoundLong);
            return null;
        }
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return String.valueOf(file.getProject().getName()) + "/" + file.getName();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(activeShell, (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.UpdateRMapAction_chooseBuildModel);
        dialog.setMessage(Messages.UpdateRMapAction_chooseBuildModelLong);
        dialog.setElements(aggregationBuildFiles.toArray());
        dialog.open();
        return (IFile)dialog.getFirstResult();
    }

    protected static Aggregation loadAggregationModel(IFile aggregationBuildFile) throws CoreException {
        Aggregation result = null;
        AggregatorPackage.eINSTANCE.getEFactoryInstance();
        URI uri = URI.createPlatformResourceURI((String)aggregationBuildFile.getFullPath().toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = null;
        try {
            resource = resourceSet.getResource(uri, true);
            resource.load(null);
        }
        catch (Exception e) {
            try {
                TransformationManager transformationManager = new TransformationManager(uri);
                resource = transformationManager.transformResource(true);
            }
            catch (Exception e1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "Error loading b3aggr. Make sure you have the latest version of B3 installed. : " + e.getLocalizedMessage(), (Throwable)e1));
            }
        }
        if (resource.getContents().size() == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "The b3aggr resource is empty"));
        }
        EObject root = (EObject)resource.getContents().get(0);
        if (!(root instanceof Aggregation)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "The b3aggr resource does not contain an aggregation model"));
        }
        result = (Aggregation)root;
        return result;
    }

    protected boolean updateFile(IFile selectedFile, Aggregation aggregationModel, Shell activeShell, Map<Object, Object> context) throws CoreException {
        boolean result = false;
        List<DependencyUpdater<?>> updaters = this.findDependencyUpdater(selectedFile);
        for (DependencyUpdater<?> updater : updaters) {
            updater.updateDocument(activeShell, selectedFile, (EList<Contribution>)aggregationModel.getAllContributions(true), context);
            result = true;
        }
        return result;
    }

    protected List<DependencyUpdater<?>> findDependencyUpdater(IFile mapFile) throws CoreException {
        String path = "org/eclipse/papyrus/releng/tools/internal/popup/actions/";
        Bundle bundle = Activator.getDefault().getBundle();
        Enumeration urls = bundle.findEntries("bin/org/eclipse/papyrus/releng/tools/internal/popup/actions/", "*.class", false);
        if (urls == null) {
            urls = bundle.findEntries("org/eclipse/papyrus/releng/tools/internal/popup/actions/", "*.class", false);
        }
        LinkedList updaters = new LinkedList();
        while (urls.hasMoreElements()) {
            URL classURL = (URL)urls.nextElement();
            URI classURI = URI.createURI((String)classURL.toExternalForm(), (boolean)true);
            try {
                DependencyUpdater updater;
                Class<DependencyUpdater> updaterClass;
                String className = classURI.trimFileExtension().lastSegment();
                if ("DependencyUpdater".equals(className) || "XMLDependencyUpdater".equals(className) || !className.endsWith("Updater") || Modifier.isAbstract((updaterClass = bundle.loadClass(String.valueOf("org/eclipse/papyrus/releng/tools/internal/popup/actions/".replace('/', '.')) + className).asSubclass(DependencyUpdater.class)).getModifiers()) || !(updater = updaterClass.newInstance()).canUpdate(mapFile)) continue;
                updaters.add(updater);
            }
            catch (ClassNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "No such class: " + classURI.lastSegment(), (Throwable)e));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "Failed to instantiated " + classURI.lastSegment(), (Throwable)e));
            }
            catch (Throwable t) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.releng.tools", "Failed to instantiate " + classURI.lastSegment(), t));
            }
        }
        return updaters;
    }
}

