/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ProjectFixture
implements TestRule {
    private IProject project;

    public final IProject getProject() {
        return this.project;
    }

    public URI getURI(IPath path) {
        return URI.createPlatformResourceURI((String)this.project.getFile(path).getFullPath().toString(), (boolean)true);
    }

    public URI getURI(String path) {
        return URI.createPlatformResourceURI((String)this.project.getFile((IPath)new Path(path)).getFullPath().toString(), (boolean)true);
    }

    public IFile getFile(URI uri) {
        return !uri.isPlatformResource() ? null : this.project.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
    }

    public IFile createFile(String relativeFilePath, Class<?> classFromBundle, String resourcePath) throws IOException {
        IFile result;
        URL resource;
        Bundle bundle = FrameworkUtil.getBundle(classFromBundle);
        URL uRL = resource = bundle == null ? null : bundle.getResource(resourcePath);
        if (resource == null) {
            throw new IOException("No such bundle resource: " + resourcePath);
        }
        Path path = new Path(relativeFilePath);
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream input = resource.openStream();){
                this.createFolders(path.removeLastSegments(1));
                result = this.project.getFile((IPath)path);
                result.create(input, false, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof IOException) {
                throw (IOException)e.getStatus().getException();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Failed to create file", e);
        }
        return result;
    }

    private void createFolders(IPath folderPath) throws CoreException {
        if (folderPath.segmentCount() > 0 && !folderPath.lastSegment().isEmpty()) {
            this.createFolders(folderPath.removeLastSegments(1));
            IFolder folder = this.project.getFolder(folderPath);
            if (!folder.isAccessible()) {
                folder.create(false, true, null);
            }
        }
    }

    public IFile createFile(Class<?> classFromBundle, String resourcePath) throws IOException {
        return this.createFile(new Path(resourcePath).lastSegment(), classFromBundle, resourcePath);
    }

    public Statement apply(final Statement base, Description description) {
        String name = description.getMethodName();
        if (name == null && (name = description.getClassName()) != null) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        final String projectName = name;
        return new Statement(){

            public void evaluate() throws Throwable {
                ProjectFixture.this.createProject(projectName);
                try {
                    base.evaluate();
                }
                finally {
                    ProjectFixture.this.deleteProject();
                }
            }
        };
    }

    protected void createProject(String name) throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (this.project.exists()) {
            this.deleteProject();
        }
        if (!this.project.exists()) {
            this.project.create(null);
        }
        if (!this.project.isOpen()) {
            this.project.open(null);
        }
        this.project.refreshLocal(2, null);
    }

    protected void deleteProject() {
        try {
            this.project.refreshLocal(2, null);
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    switch (resource.getType()) {
                        case 1: 
                        case 2: {
                            ProjectFixture.this.ensureWritable(resource);
                        }
                    }
                    return true;
                }
            });
            this.project.delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void ensureWritable(IResource resource) throws CoreException {
        ResourceAttributes attr = resource.getResourceAttributes();
        if (attr.isReadOnly()) {
            attr.setReadOnly(false);
            resource.setResourceAttributes(attr);
        }
    }

    public void setReadOnly(String projectRelativePath) {
        this.setReadOnly((IPath)new Path(projectRelativePath));
    }

    public void setReadOnly(IPath projectRelativePath) {
        this.setReadOnly(this.project.findMember(projectRelativePath));
    }

    public void setReadOnly(Resource resource) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        MatcherAssert.assertThat((String)"Cannot set non-workspace resource read-only", (Object)file, (Matcher)CoreMatchers.notNullValue());
        this.setReadOnly((IResource)file);
    }

    public void setReadOnly(IResource resource) {
        this.setReadOnly(resource, true);
    }

    public void setReadOnly(IResource resource, boolean readOnly) {
        ResourceAttributes attr = resource.getResourceAttributes();
        if (attr.isReadOnly() != readOnly) {
            attr.setReadOnly(readOnly);
            try {
                resource.setResourceAttributes(attr);
            }
            catch (CoreException e) {
                e.getLocalizedMessage();
                Assert.fail((String)String.format("Failed to make workspace resource %s: %s", readOnly ? "read-only" : "writable", e.getLocalizedMessage()));
            }
        }
    }
}

