/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.Collections;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.StyledTextReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.StyledTextStringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.uml.properties.editors.AutoCompleteReferenceDialogObservableValue;
import org.eclipse.papyrus.uml.properties.editors.AutoCompleteStyledTextStringEditor;
import org.eclipse.swt.widgets.Composite;

public class AutoCompleteReferenceDialog
extends StyledTextReferenceDialog {
    public AutoCompleteReferenceDialog(Composite parent, int style) {
        super(parent, style);
    }

    protected StyledTextStringEditor createStyledTextStringEditor(Composite parent, String initialValue, int style) {
        AutoCompleteStyledTextStringEditor editor = new AutoCompleteStyledTextStringEditor(parent, style);
        editor.setValue(initialValue);
        return editor;
    }

    protected IObservableValue createWidgetObservable(IObservableValue modelProperty) {
        AutoCompleteReferenceDialogObservableValue val = new AutoCompleteReferenceDialogObservableValue(this, this.styledTextStringEditor.getText(), modelProperty, 16);
        return val;
    }

    public void setNameResolutionHelper(INameResolutionHelper nameResolutionHelper) {
        ((AutoCompleteStyledTextStringEditor)this.styledTextStringEditor).setNameResolutionHelper(nameResolutionHelper);
    }

    protected void browseAction() {
        this.setInitialSelection(Collections.singletonList(this.getValue()));
        int result = this.dialog.open();
        if (result == 0) {
            Object[] newValue = this.dialog.getResult();
            if (newValue == null) {
                return;
            }
            if (newValue.length == 0) {
                this.setValue(null);
            } else {
                Object value = newValue[0];
                if (this.contentProvider instanceof IAdaptableContentProvider) {
                    value = ((IAdaptableContentProvider)this.contentProvider).getAdaptedValue(value);
                }
                this.setValue(value);
            }
        }
    }
}

