/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.ICompositeContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;

public class CompositeContentProvider
implements ICompositeContentProvider {
    private final List<ITreeContentProvider> contentProviders = new LinkedList<ITreeContentProvider>();

    public Object[] getElements(Object inputElement) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (ITreeContentProvider provider : this.contentProviders) {
            result.addAll(Arrays.asList(provider.getElements(inputElement)));
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (ITreeContentProvider provider : this.contentProviders) {
            result.addAll(Arrays.asList(provider.getChildren(parentElement)));
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        for (ITreeContentProvider provider : this.contentProviders) {
            Object parent = provider.getParent(element);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
        for (ITreeContentProvider provider : this.contentProviders) {
            provider.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        for (ITreeContentProvider provider : this.contentProviders) {
            provider.inputChanged(viewer, oldInput, newInput);
        }
    }

    @Override
    public boolean isValidValue(Object element) {
        for (ITreeContentProvider provider : this.contentProviders) {
            if (provider instanceof IHierarchicContentProvider) {
                if (!((IHierarchicContentProvider)provider).isValidValue(element)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void appendContentProvider(ITreeContentProvider treeContentProvider) {
        this.contentProviders.add(treeContentProvider);
    }

    public List<ITreeContentProvider> getContentProviders() {
        return this.contentProviders;
    }
}

