/**
 * Copyright (c) 2012 Mia-Software.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  	Alban Ménager (Soft-Maint) - Bug 387470 - [EFacet][Custom] Editors
 *  	Grégoire Dupé (Mia-Software) - Bug 387470 - [EFacet][Custom] Editors
 */
package org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exported.widget.creation;

import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exported.widget.IENamedElementWidget;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exported.widget.component.getorcreate.IGetOrCreateFacetSetWidget;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exported.widget.component.metaclass.IGetExtendedMetaclassWidget;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialog;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.widget.command.IGetOrCreateFilteredElementCommmandWidget;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.widget.component.properties.name.AbstractGetElementNameWidget;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.widget.IAbstractWidget;

/**
 * @see CreateFacetInFacetSetWidget
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface ICreateFacetInFacetSetWidget extends
		IENamedElementWidget<FacetSet, IGetOrCreateFilteredFacetSetWidget> {

	/**
	 * @return the getOrCreateFacetSetWidget
	 */
	IGetOrCreateFacetSetWidget getGetOrCreateFacetSetWidget();

	/**
	 * @return the selectSubTypingTypeWidget
	 */
	IAbstractWidget getSelectSubTypingTypeWidget();

	/**
	 * @return the getFacetNameWidget
	 */
	AbstractGetElementNameWidget getGetFacetNameWidget();

	/**
	 * @return the getExtendedMetaclassWidget
	 */
	IGetExtendedMetaclassWidget getGetExtendedMetaclassWidget();

	/**
	 * @return the name of the sub-typing widget.
	 */
	String getSubTypingFacet();

	IDialog<IGetOrCreateFilteredElementCommmandWidget<ETypedElement, Object>> pressSubTypingButton();

	void setSubTypingFacetSelection(final boolean enable);

}