/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromfile;

import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.papyrus.designer.deployment.tools.Activator;

public class CheckNodeInheritance {
    protected static final String LIFECYCLE_NODE = "rclcpp_lifecycle::LifecycleNode";
    protected static final String NODE = "rclcpp::Node";
    protected IASTNodeSelector selector;

    public CheckNodeInheritance(IASTTranslationUnit ast) {
        this.selector = ast.getNodeSelector(null);
    }

    public boolean isNode(ITranslationUnit itu) {
        try {
            ICPPClassType classType = this.findClass((IParent)itu);
            if (classType != null) {
                return this.isNode(classType);
            }
        }
        catch (CModelException e) {
            Activator.log.error((Throwable)e);
        }
        return false;
    }

    public ICPPClassType findClass(IParent parent) throws CModelException {
        ICPPClassType classType = null;
        ICElement[] iCElementArray = parent.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof INamespace) {
                classType = this.findClass((IParent)((INamespace)child));
            } else if (child instanceof IMethod) {
                IASTFunctionDefinition fctDef;
                IBinding binding;
                IMethod method = (IMethod)child;
                ISourceRange range = method.getSourceRange();
                IASTNode node = this.selector.findEnclosingNode(range.getStartPos(), range.getLength());
                if (node instanceof IASTFunctionDefinition && (binding = (fctDef = (IASTFunctionDefinition)node).getDeclarator().getName().resolveBinding()) instanceof ICPPMember) {
                    classType = ((ICPPMember)binding).getClassOwner();
                }
                if (classType != null) {
                    return classType;
                }
            }
            ++n2;
        }
        return classType;
    }

    public boolean isNode(ICPPClassType classType) {
        ICPPBase[] iCPPBaseArray = classType.getBases();
        int n = iCPPBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isNode;
            ICPPBase base = iCPPBaseArray[n2];
            IType baseClass = base.getBaseClassType();
            if (baseClass.toString().equals(LIFECYCLE_NODE) || baseClass.toString().equals(NODE)) {
                return true;
            }
            if (baseClass instanceof ICPPClassType && (isNode = this.isNode((ICPPClassType)baseClass))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

