/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.dashboard.ui.pages;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.robotics.dashboard.ui.pages.P4RProjectModelHyperlink;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Bundle;

public class MissionDefinitionPage {
    public static final String ID = "Robot Mission Definition";

    public ScrolledForm getPageBody(Composite container) {
        FormToolkit toolkit = new FormToolkit(container.getDisplay());
        final ScrolledForm composite = toolkit.createScrolledForm(container);
        composite.setText("Papyrus4Robotics Compositional Development Process");
        String path_mision = "icons/robotics_mision.png";
        Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.robotics.dashboard.ui");
        URL url_mision = FileLocator.find((Bundle)bundle, (IPath)new Path(path_mision), null);
        ImageDescriptor imageDescMision = ImageDescriptor.createFromURL((URL)url_mision);
        Image misionImage = imageDescMision.createImage();
        composite.setImage(misionImage);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        composite.getBody().setLayout((Layout)layout);
        toolkit.createLabel(composite.getBody(), ID);
        toolkit.createLabel(composite.getBody(), "");
        Section section1 = toolkit.createSection(composite.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        td.colspan = 2;
        section1.setLayoutData((Object)td);
        section1.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                composite.reflow(true);
            }
        });
        section1.setText("Skill Definition");
        section1.setDescription("The Skill designer (a domain expert) is able to define skill definitions modelling the interface of skills on tier 2, not yet deciding how a skill is realized. As a result, the skill definition is any component that realizes it.");
        Composite sectionClient = toolkit.createComposite((Composite)section1);
        sectionClient.setLayout((Layout)new GridLayout());
        ImageDescriptor imageDescSkill = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/skills.png"), null));
        Image skillImage = imageDescSkill.createImage();
        P4RProjectModelHyperlink.create(toolkit, sectionClient, "Create a new skills definition project", skillImage, "BehaviorDesign", true);
        P4RProjectModelHyperlink.create(toolkit, sectionClient, "Create a new skills definition model", skillImage, "BehaviorDesign", false);
        section1.setClient((Control)sectionClient);
        Section section2 = toolkit.createSection(composite.getBody(), 450);
        TableWrapData td2 = new TableWrapData(256);
        td2.colspan = 2;
        section2.setLayoutData((Object)td2);
        section2.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                composite.reflow(true);
            }
        });
        section2.setText("Behaviour Definition");
        section2.setDescription("A behaviour tree is capable of modelling task-plots of a robot. Task-plots define sequences of tasks required to achieve certain goals at run-time.");
        Composite section2Client = toolkit.createComposite((Composite)section2);
        section2Client.setLayout((Layout)new GridLayout());
        ImageDescriptor imageDescBehaviour = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/tree-16.png"), null));
        Image behaviourImage = imageDescBehaviour.createImage();
        P4RProjectModelHyperlink.create(toolkit, section2Client, "Create a new behaviour tree project", behaviourImage, "BehaviorTreeDesign", true);
        P4RProjectModelHyperlink.create(toolkit, section2Client, "Create a new behaviour tree model", behaviourImage, "BehaviorTreeDesign", false);
        section2.setClient((Control)section2Client);
        Section section3 = toolkit.createSection(composite.getBody(), 450);
        TableWrapData td3 = new TableWrapData(256);
        td3.colspan = 2;
        section3.setLayoutData((Object)td3);
        section3.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                composite.reflow(true);
            }
        });
        section3.setText("Services modeling");
        section3.setDescription("The service designer defines a Service which consists of service-properties and a communication-pattern-usage. The communication-pattern-usage selects a certain Communication Pattern with a pattern-specific selection of according number of communicated data-structures");
        Composite section3Client = toolkit.createComposite((Composite)section3);
        section3Client.setLayout((Layout)new GridLayout());
        String path3 = "icons/tree-16.png";
        URL url3 = FileLocator.find((Bundle)bundle, (IPath)new Path(path3), null);
        ImageDescriptor imageDesc3 = ImageDescriptor.createFromURL((URL)url3);
        Image image3 = imageDesc3.createImage();
        P4RProjectModelHyperlink.create(toolkit, section3Client, "Create a new services definition project", image3, "ServiceDesign", true);
        P4RProjectModelHyperlink.create(toolkit, section3Client, "Create a new services definition model", image3, "ServiceDesign", false);
        section3.setClient((Control)section3Client);
        Section section4 = toolkit.createSection(composite.getBody(), 450);
        TableWrapData td4 = new TableWrapData(256);
        td4.colspan = 2;
        section4.setLayoutData((Object)td4);
        section4.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                composite.reflow(true);
            }
        });
        section4.setText("Risk Assessment");
        section4.setDescription("The safety engineer performs a risk assessment");
        Composite section4Client = toolkit.createComposite((Composite)section4);
        section4Client.setLayout((Layout)new GridLayout());
        String path4 = "icons/hazard.png";
        URL url4 = FileLocator.find((Bundle)bundle, (IPath)new Path(path4), null);
        ImageDescriptor imageDesc4 = ImageDescriptor.createFromURL((URL)url4);
        Image image4 = imageDesc4.createImage();
        P4RProjectModelHyperlink.create(toolkit, section4Client, "Create a new Task-Based HARA project", image4, "TadkBasedHazardAnalysis", true);
        P4RProjectModelHyperlink.create(toolkit, section4Client, "Create a new Task-Based HARA model", image4, "TadkBasedHazardAnalysis", false);
        section4.setClient((Control)section4Client);
        return composite;
    }
}

