/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.validation.problems.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.papyrus.cdo.validation.problems.EProblem;
import org.eclipse.papyrus.cdo.validation.problems.EProblemsContainer;
import org.eclipse.papyrus.cdo.validation.problems.ProblemsPackage;

public class EProblemsContainerImpl
extends CDOObjectImpl
implements EProblemsContainer {
    protected EProblemsContainerImpl() {
    }

    protected EClass eStaticClass() {
        return ProblemsPackage.Literals.EPROBLEMS_CONTAINER;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    @Override
    public EList<EProblem> getProblems() {
        return (EList)this.eGet((EStructuralFeature)ProblemsPackage.Literals.EPROBLEMS_CONTAINER__PROBLEMS, true);
    }

    @Override
    public EList<EObject> getSubjects() {
        return (EList)this.eGet((EStructuralFeature)ProblemsPackage.Literals.EPROBLEMS_CONTAINER__SUBJECTS, true);
    }

    @Override
    public EList<EProblemsContainer> getSubcontainers() {
        return (EList)this.eGet((EStructuralFeature)ProblemsPackage.Literals.EPROBLEMS_CONTAINER__SUBCONTAINERS, true);
    }

    @Override
    public EProblemsContainer getContainer() {
        return (EProblemsContainer)this.eGet((EStructuralFeature)ProblemsPackage.Literals.EPROBLEMS_CONTAINER__CONTAINER, true);
    }

    @Override
    public void setContainer(EProblemsContainer newContainer) {
        this.eSet((EStructuralFeature)ProblemsPackage.Literals.EPROBLEMS_CONTAINER__CONTAINER, newContainer);
    }

    @Override
    public Iterator<EProblem> allProblems() {
        return new EProblemsIterator((Iterator<?>)this.eAllContents());
    }

    @Override
    public Iterator<EProblem> allProblems(final EObject element) {
        return new EProblemsIterator((Iterator)this.eAllContents()){

            @Override
            protected boolean accept(EProblem problem) {
                return problem.getElement() == element;
            }
        };
    }

    @Override
    public EList<Diagnostic> allDiagnostics() {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        Iterator<EProblem> allProblems = this.allProblems();
        while (allProblems.hasNext()) {
            result.add(allProblems.next().toDiagnostic());
        }
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    @Override
    public EList<Diagnostic> allDiagnostics(EObject element) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        Iterator<EProblem> allProblems = this.allProblems(element);
        while (allProblems.hasNext()) {
            result.add(allProblems.next().toDiagnostic());
        }
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    @Override
    public EProblem getWorstProblem(EObject element) {
        EProblem result = null;
        Iterator<EProblem> problems = this.allProblems(element);
        while (problems.hasNext()) {
            EProblem next = problems.next();
            if (result == null) {
                result = next;
                continue;
            }
            if (next.getSeverity().compareTo(result.getSeverity()) <= 0) continue;
            result = next;
        }
        return result;
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allProblems();
            }
            case 1: {
                return this.allProblems((EObject)arguments.get(0));
            }
            case 2: {
                return this.allDiagnostics();
            }
            case 3: {
                return this.allDiagnostics((EObject)arguments.get(0));
            }
            case 4: {
                return this.getWorstProblem((EObject)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    private static class EProblemsIterator
    implements Iterator<EProblem> {
        private final Iterator<?> delegate;
        private EProblem preparedNext;

        public EProblemsIterator(Iterator<?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            if (this.preparedNext == null) {
                while (this.delegate.hasNext()) {
                    EProblem problem;
                    Object next = this.delegate.next();
                    if (!(next instanceof EProblem) || !this.accept(problem = (EProblem)next)) continue;
                    this.preparedNext = problem;
                    break;
                }
            }
            return this.preparedNext != null;
        }

        protected boolean accept(EProblem problem) {
            return true;
        }

        @Override
        public EProblem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EProblem result = this.preparedNext;
            this.preparedNext = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

