/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.tracepoint.view;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpointImportParticipant;
import org.eclipse.debug.ui.actions.ImportBreakpointsOperation;
import org.eclipse.papyrus.moka.ui.tracepoint.view.Activator;

public class ImportTracepointsOperation
extends ImportBreakpointsOperation {
    IMarker[] markers;

    public ImportTracepointsOperation(String fileName) {
        super(fileName, true, true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            if (root != null) {
                this.markers = root.findMarkers("org.eclipse.papyrus.tracepointmarker", true, 2);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logger.error("Error occured while finding markers for " + root, (Throwable)e);
        }
    }

    protected IMarker findExistingMarker(Map<String, Object> attributes, IBreakpointImportParticipant[] participants) {
        Object uri = attributes.get("uri");
        IMarker[] iMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String uriOfMarkerStr = marker.getAttribute("uri", "");
            if (uriOfMarkerStr.equals(uri)) {
                return marker;
            }
            ++n2;
        }
        return null;
    }
}

