/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.simpleclassifiers;

import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IRealValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IntegerValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.PrimitiveValue;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class RealValue
extends PrimitiveValue
implements IRealValue {
    public double value;

    @Override
    public ValueSpecification specify() {
        LiteralReal literal = UMLFactory.eINSTANCE.createLiteralReal();
        literal.setType((Type)this.type);
        literal.setValue(this.value);
        return literal;
    }

    @Override
    public Boolean equals(IValue otherValue) {
        boolean isEqual = false;
        if (otherValue instanceof RealValue) {
            isEqual = ((RealValue)otherValue).value == this.value;
        }
        return isEqual;
    }

    @Override
    public IValue copy() {
        RealValue newValue = (RealValue)super.copy();
        newValue.value = this.value;
        return newValue;
    }

    @Override
    public IValue new_() {
        return new RealValue();
    }

    @Override
    public String toString() {
        String stringValue = "";
        if (this.value == 0.0) {
            stringValue = "0";
        } else {
            double positiveValue = this.value;
            if (positiveValue < 0.0) {
                positiveValue = -positiveValue;
            }
            int exponent = 0;
            if (positiveValue < 0.1) {
                while (positiveValue < 0.1) {
                    positiveValue *= 10.0;
                    --exponent;
                }
            } else if (positiveValue >= 1.0) {
                while (positiveValue >= 1.0) {
                    positiveValue /= 10.0;
                    ++exponent;
                }
            }
            int i = 0;
            while (i < 9) {
                positiveValue *= 10.0;
                ++i;
            }
            IntegerValue integerValue = new IntegerValue();
            integerValue.value = (int)positiveValue;
            stringValue = "0." + integerValue.toString();
            integerValue.value = exponent;
            stringValue = String.valueOf(stringValue) + "E" + integerValue.toString();
            if (this.value < 0.0) {
                stringValue = "-" + stringValue;
            }
        }
        return stringValue;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }
}

