/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.activities.ControlNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IDecisionNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ParameterValue;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.loci.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityEdgeInstanceProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.loci.ExecutionFactoryProfiler;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.BooleanValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;

public class DecisionNodeActivation
extends ControlNodeActivation
implements IDecisionNodeActivation {
    public IExecution decisionInputExecution;

    @Override
    public void fire(List<IToken> incomingTokens) {
        Debug.println("[fire] Decision node " + this.node.getName() + "...");
        List<IToken> removedControlTokens = this.removeJoinedControlTokens(incomingTokens);
        List<IValue> decisionValues = this.getDecisionValues(incomingTokens);
        List<IActivityEdgeInstance> outgoingEdges = this.getOutgoingEdges();
        int i = 0;
        while (i < outgoingEdges.size()) {
            IActivityEdgeInstance edgeInstance = outgoingEdges.get(i);
            ValueSpecification guard = edgeInstance.getEdge().getGuard();
            ArrayList<IToken> offeredTokens = new ArrayList<IToken>();
            int j = 0;
            while (j < incomingTokens.size()) {
                IToken incomingToken = incomingTokens.get(j);
                IValue decisionValue = decisionValues.get(j);
                if (this.test(guard, decisionValue).booleanValue()) {
                    offeredTokens.add(incomingToken);
                }
                ++j;
            }
            if (offeredTokens.size() > 0) {
                j = 0;
                while (j < removedControlTokens.size()) {
                    IToken removedControlToken = removedControlTokens.get(j);
                    offeredTokens.add(removedControlToken);
                    ++j;
                }
                ArrayList<IToken> arrayList = offeredTokens;
                IActivityEdgeInstance iActivityEdgeInstance = edgeInstance;
                ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$1$49177e35(iActivityEdgeInstance, arrayList);
                iActivityEdgeInstance.sendOffer(arrayList);
            }
            ++i;
        }
    }

    public List<IValue> getDecisionValues(List<IToken> incomingTokens) {
        IValue decisionInputValue = this.getDecisionInputFlowValue();
        ArrayList<IValue> decisionValues = new ArrayList<IValue>();
        int i = 0;
        while (i < incomingTokens.size()) {
            IToken incomingToken = incomingTokens.get(i);
            IValue value = this.executeDecisionInputBehavior(incomingToken.getValue(), decisionInputValue);
            decisionValues.add(value);
            ++i;
        }
        i = 0;
        while (i < decisionValues.size()) {
            IValue decisionValue = (IValue)decisionValues.get(i);
            Debug.println("[getDecisionValues] decisionValues[" + i + "] = " + decisionValue);
            ++i;
        }
        return decisionValues;
    }

    public IValue executeDecisionInputBehavior(IValue inputValue, IValue decisionInputValue) {
        Debug.println("[executeDecisionBehavior] inputValue = " + inputValue);
        Behavior decisionInputBehavior = ((DecisionNode)this.node).getDecisionInput();
        IValue decisionInputResult = null;
        if (decisionInputBehavior == null) {
            decisionInputResult = decisionInputValue != null ? decisionInputValue : inputValue;
        } else {
            IObject_ iObject_ = this.getExecutionContext();
            Behavior behavior = decisionInputBehavior;
            IExecutionFactory iExecutionFactory = this.getExecutionLocus().getFactory();
            IExecution iExecution = iExecutionFactory.createExecution(behavior, iObject_);
            ExecutionFactoryProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_loci_ExecutionFactoryProfiler$1$835cd872(iExecutionFactory, behavior, iObject_, iExecution);
            this.decisionInputExecution = iExecution;
            int i = 1;
            int j = 0;
            while ((j == 0 | j == 1 & decisionInputValue != null) & i <= decisionInputBehavior.getOwnedParameters().size()) {
                Parameter parameter = (Parameter)decisionInputBehavior.getOwnedParameters().get(i - 1);
                if (parameter.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL) | parameter.getDirection().equals((Object)ParameterDirectionKind.INOUT_LITERAL)) {
                    ParameterValue inputParameterValue = new ParameterValue();
                    inputParameterValue.parameter = parameter;
                    if (++j == 1 && inputValue != null) {
                        inputParameterValue.values.add(inputValue);
                    } else {
                        inputParameterValue.values.add(decisionInputValue);
                    }
                    this.decisionInputExecution.setParameterValue((IParameterValue)inputParameterValue);
                }
                ++i;
            }
            this.decisionInputExecution.execute();
            List outputParameterValues = this.decisionInputExecution.getOutputParameterValues();
            this.decisionInputExecution.destroy();
            if (((IParameterValue)outputParameterValues.get(0)).getValues().size() == 0) {
                decisionInputResult = new BooleanValue();
                ((BooleanValue)decisionInputResult).value = true;
            } else {
                decisionInputResult = (IValue)((IParameterValue)outputParameterValues.get(0)).getValues().get(0);
            }
        }
        return decisionInputResult;
    }

    @Override
    public void terminate() {
        if (this.decisionInputExecution != null) {
            this.decisionInputExecution.terminate();
        }
        super.terminate();
    }

    @Override
    public Boolean isReady() {
        int i = 1;
        boolean ready = true;
        while (ready & i <= this.incomingEdges.size()) {
            ready = ((IActivityEdgeInstance)this.incomingEdges.get(i - 1)).hasOffer();
            ++i;
        }
        return ready;
    }

    @Override
    public List<IToken> takeOfferedTokens() {
        ObjectFlow decisionInputFlow = ((DecisionNode)this.node).getDecisionInputFlow();
        ArrayList<IToken> allTokens = new ArrayList<IToken>();
        List<IActivityEdgeInstance> incomingEdges = this.getIncomingEdges();
        int i = 0;
        while (i < incomingEdges.size()) {
            IActivityEdgeInstance edgeInstance = incomingEdges.get(i);
            if (edgeInstance.getEdge() != decisionInputFlow) {
                IActivityEdgeInstance iActivityEdgeInstance = edgeInstance;
                List list = iActivityEdgeInstance.takeOfferedTokens();
                ActivityEdgeInstanceProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$2$2af4857d(iActivityEdgeInstance, list);
                List tokens = list;
                int j = 0;
                while (j < tokens.size()) {
                    allTokens.add((IToken)tokens.get(j));
                    ++j;
                }
            }
            ++i;
        }
        return allTokens;
    }

    public IValue getDecisionInputFlowValue() {
        IActivityEdgeInstance decisionInputFlowInstance = this.getDecisionInputFlowInstance();
        IValue value = null;
        if (decisionInputFlowInstance != null) {
            IActivityEdgeInstance iActivityEdgeInstance = decisionInputFlowInstance;
            List list = iActivityEdgeInstance.takeOfferedTokens();
            ActivityEdgeInstanceProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$2$2af4857d(iActivityEdgeInstance, list);
            List tokens = list;
            if (tokens.size() > 0) {
                value = ((IToken)tokens.get(0)).getValue();
            }
        }
        return value;
    }

    public IActivityEdgeInstance getDecisionInputFlowInstance() {
        ObjectFlow decisionInputFlow = ((DecisionNode)this.node).getDecisionInputFlow();
        IActivityEdgeInstance edgeInstance = null;
        if (decisionInputFlow != null) {
            int i = 1;
            while (edgeInstance == null & i <= this.getIncomingEdges().size()) {
                IActivityEdgeInstance incomingEdge = this.getIncomingEdges().get(i - 1);
                if (incomingEdge.getEdge() == decisionInputFlow) {
                    edgeInstance = incomingEdge;
                }
                ++i;
            }
        }
        return edgeInstance;
    }

    public Boolean test(ValueSpecification guard, IValue value) {
        boolean guardResult = true;
        if (guard != null) {
            IValue guardValue = this.getExecutionLocus().getExecutor().evaluate(guard);
            guardResult = guardValue.equals(value);
        }
        return guardResult;
    }

    public List<IToken> removeJoinedControlTokens(List<IToken> incomingTokens) {
        ArrayList<IToken> removedControlTokens = new ArrayList<IToken>();
        if (this.hasObjectFlowInput().booleanValue()) {
            int i = 1;
            while (i <= incomingTokens.size()) {
                IToken token = incomingTokens.get(i - 1);
                if (token.isControl().booleanValue()) {
                    removedControlTokens.add(token);
                    incomingTokens.remove(i - 1);
                    --i;
                }
                ++i;
            }
        }
        return removedControlTokens;
    }

    public Boolean hasObjectFlowInput() {
        ObjectFlow decisionInputFlow = ((DecisionNode)this.node).getDecisionInputFlow();
        boolean isObjectFlow = false;
        int i = 1;
        while (!isObjectFlow & i <= this.incomingEdges.size()) {
            ActivityEdge edge = ((IActivityEdgeInstance)this.incomingEdges.get(i - 1)).getEdge();
            isObjectFlow = edge != decisionInputFlow & edge instanceof ObjectFlow;
            ++i;
        }
        return isObjectFlow;
    }
}

