/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.pssm.statemachines.IPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IRegionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.ITransitionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.VertexActivation;

public abstract class PseudostateActivation
extends VertexActivation
implements IPseudostateActivation {
    protected List<ITransitionActivation> fireableTransitions = new ArrayList<ITransitionActivation>();

    public void evaluateAllGuards(IEventOccurrence eventOccurrence) {
        this.fireableTransitions.clear();
        int i = 0;
        while (i < this.outgoingTransitionActivations.size()) {
            ITransitionActivation transitionActivation = (ITransitionActivation)this.outgoingTransitionActivations.get(i);
            if (transitionActivation.evaluateGuard(eventOccurrence)) {
                this.fireableTransitions.add(transitionActivation);
            }
            ++i;
        }
    }

    @Override
    public boolean canPropagateExecution(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        boolean propagate = super.canPropagateExecution(enteringTransition, eventOccurrence, leastCommonAncestor);
        if (propagate && this.isEnterable(enteringTransition, true) && this.outgoingTransitionActivations.size() > 0) {
            this.evaluateAllGuards(eventOccurrence);
            propagate = false;
            if (this.fireableTransitions.size() > 0) {
                int i = 0;
                while (!propagate && i < this.fireableTransitions.size()) {
                    propagate = this.fireableTransitions.get(i).canPropagateExecution(eventOccurrence);
                    ++i;
                }
            }
        }
        return propagate;
    }
}

