/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.utils.GenerateODTFileUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GenerateODTFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TextDocument docTemplate = this.getSelectedTextDocument();
        if (docTemplate != null) {
            GenerateODTFileUtils.generateODTFile(docTemplate);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Papyrus-Model2Doc", (String)"The odt file has been generated.");
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.getSelectedTextDocument() != null);
    }

    private TextDocument getSelectedTextDocument() {
        ISelection selection;
        ISelectionService ss;
        IWorkbenchWindow wW;
        Object firstSelectedElement = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wW = wb.getActiveWorkbenchWindow()) != null && (ss = wW.getSelectionService()) != null && (selection = ss.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            firstSelectedElement = ((IStructuredSelection)selection).getFirstElement();
        }
        if (firstSelectedElement instanceof IAdaptable) {
            firstSelectedElement = ((IAdaptable)firstSelectedElement).getAdapter(EObject.class);
        }
        if (firstSelectedElement instanceof TextDocument) {
            return (TextDocument)firstSelectedElement;
        }
        return null;
    }
}

