/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.ui.handler;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.DefaultDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.GeneratorConfigurationFactory;
import org.eclipse.papyrus.model2doc.core.transcriber.Transcriber;
import org.eclipse.papyrus.model2doc.core.transcriber.TranscriberFactory;
import org.eclipse.papyrus.model2doc.documentview.ui.menu.handler.CreateDocumentViewEditorHandler;
import org.eclipse.papyrus.model2doc.odt.transcription.ODTTranscriptionFactory;
import org.eclipse.papyrus.model2doc.odt.ui.Activator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class GeneratorUML2ODTHandler
extends CreateDocumentViewEditorHandler {
    private String generatedDocumentFileURI;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    public boolean generateDocument(String name) {
        Element selectedElement = this.getSelection();
        if (selectedElement == null || selectedElement.eResource() == null) {
            return false;
        }
        URI uri = selectedElement.eResource().getURI();
        uri = uri.trimFileExtension();
        uri = uri.trimSegments(uri.segmentsList().size() - 2);
        String projectFolder = uri.toString();
        DefaultDocumentGeneratorConfiguration configuration = GeneratorConfigurationFactory.eINSTANCE.createDefaultDocumentGeneratorConfiguration();
        configuration.setDocumentName(name);
        configuration.setDocumentFolder(projectFolder);
        String templateFileURI = "platform:/plugin/org.eclipse.papyrus.model2doc.odt/template/PapyrusTemplate.ott";
        configuration.setTemplateFile("platform:/plugin/org.eclipse.papyrus.model2doc.odt/template/PapyrusTemplate.ott");
        try {
            Transcriber umlTranscriber = TranscriberFactory.INSTANCE.createUMLTranscriber((Package)this.getSelection(), ODTTranscriptionFactory.INSTANCE.getDefaultODTTranscription(null, configuration));
            umlTranscriber.transcribe();
            StringBuilder uriBuilder = new StringBuilder();
            uriBuilder.append(projectFolder);
            uriBuilder.append(File.separator);
            uriBuilder.append(name);
            uriBuilder.append(".odt");
            Path path = new Path(uriBuilder.toString());
            this.generatedDocumentFileURI = path.toString();
            this.getWorkspaceResourceService().refreshWorkspace(projectFolder);
            return true;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return false;
        }
    }

    public String getGeneratedDocumentFileURI() {
        return this.generatedDocumentFileURI;
    }
}

