/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.ieee.requirements.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.documentation.AbstractRequirements;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.documentation.IEEEFunctionalRequirements;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.documentation.IEEERequirements;
import org.eclipse.uml2.uml.Package;

public class IEEERequirementsDocumentationProfileHelper {
    private Package rootPackage;
    private final Collection<Package> specificRequirements = new ArrayList<Package>();
    private final Collection<Package> externalInterfaceRequirements = new ArrayList<Package>();
    private final Collection<Package> userInterfaces = new ArrayList<Package>();
    private final Collection<Package> hardwaresInterfaces = new ArrayList<Package>();
    private final Collection<Package> softwareInterfaces = new ArrayList<Package>();
    private final Collection<Package> communicationInterfaces = new ArrayList<Package>();
    private final Collection<Package> functionalRequirementsWithoutMode = new ArrayList<Package>();
    private final Map<Integer, Collection<Package>> functionalRequirementsWithMode = new HashMap<Integer, Collection<Package>>();
    private final Collection<Package> performanceRequirements = new ArrayList<Package>();
    private final Collection<Package> designConstraints = new ArrayList<Package>();
    private final Collection<Package> softwareSystemAttributes = new ArrayList<Package>();
    private final Collection<Package> otherRequirements = new ArrayList<Package>();
    final Collection<Package> unknownRequirements = new ArrayList<Package>();

    public IEEERequirementsDocumentationProfileHelper(Package aPackage) {
        this.rootPackage = aPackage;
        this.fillCollections(this.rootPackage);
    }

    protected void fillCollections(Package pack) {
        for (Package current : pack.getOwnedMembers().stream().filter(Package.class::isInstance).map(Package.class::cast).collect(Collectors.toList())) {
            this.addToCollection(current);
            this.fillCollections(current);
        }
    }

    protected void addToCollection(Package pack) {
        for (EObject current : pack.getStereotypeApplications()) {
            IEEERequirements reqSte;
            if (current instanceof IEEEFunctionalRequirements) {
                reqSte = (IEEEFunctionalRequirements)current;
                Integer mode = reqSte.getMode();
                Collection<Package> packages = this.functionalRequirementsWithMode.get(mode);
                if (packages == null) {
                    packages = new ArrayList<Package>();
                    this.functionalRequirementsWithMode.put(mode, packages);
                }
                packages.add(pack);
                continue;
            }
            if (current instanceof IEEERequirements) {
                reqSte = (IEEERequirements)current;
                switch (reqSte.getCategory()) {
                    case SPECIFIC_REQUIREMENTS: {
                        this.specificRequirements.add(pack);
                        break;
                    }
                    case EXTERNAL_INTERFACE_REQUIREMENTS: {
                        this.externalInterfaceRequirements.add(pack);
                        break;
                    }
                    case USER_INTERFACES: {
                        this.userInterfaces.add(pack);
                        break;
                    }
                    case HARDWARE_INTERFACES: {
                        this.hardwaresInterfaces.add(pack);
                        break;
                    }
                    case SOFTWARE_INTERFACES: {
                        this.softwareInterfaces.add(pack);
                        break;
                    }
                    case COMMUNICATION_INTERFACES: {
                        this.communicationInterfaces.add(pack);
                        break;
                    }
                    case FUNCTIONAL_REQUIREMENTS: {
                        this.functionalRequirementsWithoutMode.add(pack);
                        break;
                    }
                    case PERFORMANCE_REQUIREMENTS: {
                        this.performanceRequirements.add(pack);
                        break;
                    }
                    case DESIGN_CONSTRAINTS: {
                        this.designConstraints.add(pack);
                        break;
                    }
                    case SOFTWARE_SYSTEM_ATTRIBUTES: {
                        this.softwareSystemAttributes.add(pack);
                        break;
                    }
                    case OTHER_REQUIREMENTS: {
                        this.otherRequirements.add(pack);
                        break;
                    }
                    default: {
                        this.unknownRequirements.add(pack);
                        break;
                    }
                }
                continue;
            }
            if (!(current instanceof AbstractRequirements)) continue;
            this.unknownRequirements.add(pack);
        }
    }

    public final Collection<Package> getSpecificRequirements() {
        return this.specificRequirements;
    }

    public final Collection<Package> getExternalInterfaceRequirements() {
        return this.externalInterfaceRequirements;
    }

    public final Collection<Package> getUserInterfaces() {
        return this.userInterfaces;
    }

    public final Collection<Package> getHardwaresInterfaces() {
        return this.hardwaresInterfaces;
    }

    public final Collection<Package> getSoftwareInterfaces() {
        return this.softwareInterfaces;
    }

    public final Collection<Package> getCommunicationInterfaces() {
        return this.communicationInterfaces;
    }

    public final Collection<Package> getFunctionalRequirementsWithoutMode() {
        return this.functionalRequirementsWithoutMode;
    }

    public final Map<Integer, Collection<Package>> getFunctionalRequirementsWithMode() {
        return this.functionalRequirementsWithMode;
    }

    public final Collection<Package> getPerformanceRequirements() {
        return this.performanceRequirements;
    }

    public final Collection<Package> getDesignConstraints() {
        return this.designConstraints;
    }

    public final Collection<Package> getSoftwareSystemAttributes() {
        return this.softwareSystemAttributes;
    }

    public final Collection<Package> getOtherRequirements() {
        return this.otherRequirements;
    }

    public final Collection<Package> getUnknownRequirements() {
        return this.unknownRequirements;
    }
}

